/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjn;
import com.google.android.gms.internal.contextmanager.zzlc;
import com.google.android.gms.internal.contextmanager.zzlg;
import com.google.android.gms.internal.contextmanager.zzli;
import com.google.android.gms.internal.contextmanager.zzmx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzld
extends zzjn<Integer>
implements zzlg,
zzmx,
RandomAccess {
    private static final zzld zzaek = new zzld(new int[0], 0);
    private int[] zzael;
    private int size;

    public static zzld zzdx() {
        return zzaek;
    }

    zzld() {
        this(new int[10], 0);
    }

    private zzld(int[] nArray, int n) {
        this.zzael = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzael, n2, this.zzael, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzld)) {
            return super.equals(object);
        }
        zzld zzld2 = (zzld)object;
        if (this.size != zzld2.size) {
            return false;
        }
        int[] nArray = zzld2.zzael;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzael[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzael[i];
        }
        return n;
    }

    @Override
    public final zzlg zzbq(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzld(Arrays.copyOf(this.zzael, n), this.size);
    }

    public final int getInt(int n) {
        this.zzat(n);
        return this.zzael[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzbr(int n) {
        this.zzcj();
        if (this.size == this.zzael.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzael, 0, nArray, 0, this.size);
            this.zzael = nArray;
        }
        this.zzael[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcj();
        zzlc.checkNotNull(collection);
        if (!(collection instanceof zzld)) {
            return super.addAll(collection);
        }
        zzld zzld2 = (zzld)collection;
        if (zzld2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzld2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzld2.size;
        if (n > this.zzael.length) {
            this.zzael = Arrays.copyOf(this.zzael, n);
        }
        System.arraycopy(zzld2.zzael, 0, this.zzael, this.size, zzld2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzael[i])) continue;
            System.arraycopy(this.zzael, i + 1, this.zzael, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzat(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzau(n));
        }
    }

    private final String zzau(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzld zzld2 = this;
        zzld2.zzcj();
        zzld2.zzat(n);
        int n4 = zzld2.zzael[n];
        zzld2.zzael[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzld zzld2 = this;
        zzld2.zzcj();
        zzld2.zzat(n);
        int n2 = zzld2.zzael[n];
        if (n < zzld2.size - 1) {
            System.arraycopy(zzld2.zzael, n + 1, zzld2.zzael, n, zzld2.size - n - 1);
        }
        --zzld2.size;
        ++zzld2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzld zzld2 = this;
        zzld2.zzcj();
        if (n < 0 || n > zzld2.size) {
            throw new IndexOutOfBoundsException(zzld2.zzau(n));
        }
        if (zzld2.size < zzld2.zzael.length) {
            System.arraycopy(zzld2.zzael, n, zzld2.zzael, n + 1, zzld2.size - n);
        } else {
            int[] nArray = new int[zzld2.size * 3 / 2 + 1];
            System.arraycopy(zzld2.zzael, 0, nArray, 0, n);
            System.arraycopy(zzld2.zzael, n, nArray, n + 1, zzld2.size - n);
            zzld2.zzael = nArray;
        }
        zzld2.zzael[n] = n3;
        ++zzld2.size;
        ++zzld2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzbr(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzli zzav(int n) {
        return this.zzbq(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzaek.zzci();
    }
}

