/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.contextmanager.zzr;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

@SafeParcelable.Reserved(value={1000, 2, 3, 12, 13, 16, 18, 21, 22})
@SafeParcelable.Class(creator="AwarenessPlaceEntityCreator")
public final class zzp
extends AbstractSafeParcelable
implements Place {
    public static final Parcelable.Creator<zzp> CREATOR = new zzr();
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zzu;
    @SafeParcelable.Field(id=4, getter="getLatLng")
    private final LatLng latLng;
    @SafeParcelable.Field(id=5, getter="getLevelNumber")
    private final float zzv;
    @SafeParcelable.Field(id=6, getter="getViewport")
    private final LatLngBounds zzw;
    @SafeParcelable.Field(id=7, getter="getTimeZoneId")
    private final String zzx;
    @SafeParcelable.Field(id=8, getter="getWebsiteUri")
    private final Uri zzy;
    @SafeParcelable.Field(id=9, getter="isPermanentlyClosed")
    private final boolean zzz;
    @SafeParcelable.Field(id=10, getter="getRating")
    private final float zzaa;
    @SafeParcelable.Field(id=11, getter="getPriceLevel")
    private final int zzab;
    @SafeParcelable.Field(id=19, getter="getName")
    private final String name;
    @SafeParcelable.Field(id=14, getter="getAddress")
    private final String zzac;
    @SafeParcelable.Field(id=15, getter="getPhoneNumber")
    private final String zzad;
    @SafeParcelable.Field(id=17, getter="getAttributionsList")
    private final List<String> zzae;
    @SafeParcelable.Field(id=20, getter="getPlaceTypes")
    private final List<Integer> zzaf;
    @SafeParcelable.Field(id=23, getter="getAdrAddress")
    private final String zzag;
    private Locale locale;

    @SafeParcelable.Constructor
    zzp(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=20) List<Integer> list, @SafeParcelable.Param(id=19) String string2, @SafeParcelable.Param(id=14) String string3, @SafeParcelable.Param(id=15) String string4, @SafeParcelable.Param(id=17) List<String> list2, @SafeParcelable.Param(id=4) LatLng latLng, @SafeParcelable.Param(id=5) float f, @SafeParcelable.Param(id=6) LatLngBounds latLngBounds, @SafeParcelable.Param(id=7) String string5, @SafeParcelable.Param(id=8) Uri uri, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=10) float f2, @SafeParcelable.Param(id=11) int n, @SafeParcelable.Param(id=23) String string6) {
        this.zzu = string;
        this.zzaf = Collections.unmodifiableList(list);
        this.name = string2;
        this.zzac = string3;
        this.zzad = string4;
        this.zzae = list2 != null ? list2 : Collections.emptyList();
        this.latLng = latLng;
        this.zzv = f;
        this.zzw = latLngBounds;
        this.zzx = string5 != null ? string5 : "UTC";
        this.zzy = uri;
        this.zzz = bl;
        this.zzaa = f2;
        this.zzab = n;
        this.locale = null;
        this.zzag = string6;
    }

    @VisibleForTesting
    public final String getId() {
        return this.zzu;
    }

    public final List<Integer> getPlaceTypes() {
        return this.zzaf;
    }

    public final Locale getLocale() {
        return null;
    }

    public final LatLng getLatLng() {
        return this.latLng;
    }

    public final LatLngBounds getViewport() {
        return this.zzw;
    }

    public final Uri getWebsiteUri() {
        return this.zzy;
    }

    @Nullable
    public final CharSequence getAttributions() {
        if (this.zzae == null || this.zzae.isEmpty()) {
            return null;
        }
        return TextUtils.join((CharSequence)", ", this.zzae);
    }

    public final float getRating() {
        return this.zzaa;
    }

    public final int getPriceLevel() {
        return this.zzab;
    }

    @SuppressLint(value={"DefaultLocale"})
    public final String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("id", (Object)this.zzu).add("placeTypes", this.zzaf).add("locale", null).add("name", (Object)this.name).add("address", (Object)this.zzac).add("phoneNumber", (Object)this.zzad).add("latlng", (Object)this.latLng).add("viewport", (Object)this.zzw).add("websiteUri", (Object)this.zzy).add("isPermanentlyClosed", (Object)this.zzz).add("priceLevel", (Object)this.zzab).toString();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzu, null});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzp)) {
            return false;
        }
        zzp zzp2 = (zzp)((Object)object);
        return this.zzu.equals(zzp2.zzu) && Objects.equal(null, null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzp zzp2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzp2.getId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)zzp2.getLatLng(), (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)zzp2.zzv);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)zzp2.getViewport(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzp2.zzx, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)zzp2.getWebsiteUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzp2.zzz);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)10, (float)zzp2.getRating());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)11, (int)zzp2.getPriceLevel());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)14, (String)((String)zzp2.getAddress()), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)15, (String)((String)zzp2.getPhoneNumber()), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)17, zzp2.zzae, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)19, (String)((String)zzp2.getName()), (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)20, zzp2.getPlaceTypes(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)23, (String)zzp2.zzag, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isDataValid() {
        return true;
    }

    public final /* synthetic */ CharSequence getPhoneNumber() {
        return this.zzad;
    }

    public final /* synthetic */ CharSequence getName() {
        return this.name;
    }

    public final /* synthetic */ CharSequence getAddress() {
        return this.zzac;
    }
}

