/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.awareness.state.BeaconState;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.contextmanager.zzbg;
import com.google.android.gms.internal.contextmanager.zzdx;
import com.google.android.gms.internal.contextmanager.zzjs;
import com.google.android.gms.internal.contextmanager.zzk;
import com.google.android.gms.internal.contextmanager.zzkm;
import com.google.android.gms.internal.contextmanager.zzlb;
import com.google.android.gms.internal.contextmanager.zzll;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TypeFilterImplCreator")
public final class zzx
extends BeaconState.TypeFilter {
    public static final Parcelable.Creator<zzx> CREATOR = new zzbg();
    @SafeParcelable.Field(id=2, getter="getTypeFilterAsBytes", type="byte[]")
    private final zzdx.zza zzal;

    @SafeParcelable.Constructor
    zzx(@SafeParcelable.Param(id=2) byte[] byArray) {
        zzdx.zza zza2 = null;
        try {
            zza2 = zzdx.zza.zza(byArray, zzkm.zzcx());
        }
        catch (zzll zzll2) {
            zzk.zza("BeaconStateImpl", "Could not deserialize BeaconFence.BeaconTypeFilter");
        }
        this.zzal = zza2;
    }

    public zzx(String string, String string2) {
        this.zzal = (zzdx.zza)((zzlb)zzdx.zza.zzah().zzb(Preconditions.checkNotEmpty((String)string)).zzc(Preconditions.checkNotEmpty((String)string2)).zzdn());
    }

    public zzx(String string, String string2, byte[] byArray) {
        this.zzal = (zzdx.zza)((zzlb)zzdx.zza.zzah().zzb(Preconditions.checkNotEmpty((String)string)).zzc(Preconditions.checkNotEmpty((String)string2)).zza(zzjs.zza((byte[])Preconditions.checkNotNull((Object)byArray))).zzdn());
    }

    private final String getNamespace() {
        if (this.zzal == null) {
            return null;
        }
        return this.zzal.getNamespace();
    }

    private final String getType() {
        if (this.zzal == null) {
            return null;
        }
        return this.zzal.getType();
    }

    private final byte[] getContent() {
        if (this.zzal == null || this.zzal.zzag().size() == 0) {
            return null;
        }
        return this.zzal.zzag().toByteArray();
    }

    public final zzdx.zza zzf() {
        return this.zzal;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNamespace(), this.getType(), this.getContent() == null ? 0 : Arrays.hashCode(this.getContent())});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzx)) {
            return false;
        }
        zzx zzx2 = (zzx)((Object)object);
        return TextUtils.equals((CharSequence)this.getNamespace(), (CharSequence)zzx2.getNamespace()) && TextUtils.equals((CharSequence)this.getType(), (CharSequence)zzx2.getType()) && Arrays.equals(this.getContent(), zzx2.getContent());
    }

    public final String toString() {
        String string = this.getNamespace();
        String string2 = this.getType();
        String string3 = this.getContent() == null ? "null" : new String(this.getContent());
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string).append(",").append(string2).append(",").append(string3).append(")").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzx zzx2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])zzx2.zzal.toByteArray(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

