/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjb;
import com.google.android.gms.internal.contextmanager.zzku;
import com.google.android.gms.internal.contextmanager.zzla;
import com.google.android.gms.internal.contextmanager.zzml;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzji
extends zzjb<Boolean>
implements zzla<Boolean>,
zzml,
RandomAccess {
    private static final zzji zzyo = new zzji(new boolean[0], 0);
    private boolean[] zzyp;
    private int size;

    zzji() {
        this(new boolean[10], 0);
    }

    private zzji(boolean[] blArray, int n) {
        this.zzyp = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcg();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyp, n2, this.zzyp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzji)) {
            return super.equals(object);
        }
        zzji zzji2 = (zzji)object;
        if (this.size != zzji2.size) {
            return false;
        }
        boolean[] blArray = zzji2.zzyp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyp[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzku.zze(this.zzyp[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzcg();
        if (this.size == this.zzyp.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyp, 0, blArray, 0, this.size);
            this.zzyp = blArray;
        }
        this.zzyp[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzcg();
        zzku.checkNotNull(collection);
        if (!(collection instanceof zzji)) {
            return super.addAll(collection);
        }
        zzji zzji2 = (zzji)collection;
        if (zzji2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzji2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzji2.size;
        if (n > this.zzyp.length) {
            this.zzyp = Arrays.copyOf(this.zzyp, n);
        }
        System.arraycopy(zzji2.zzyp, 0, this.zzyp, this.size, zzji2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcg();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyp[i])) continue;
            System.arraycopy(this.zzyp, i + 1, this.zzyp, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzji zzji2 = this;
        zzji2.zzcg();
        zzji2.zzaw(n);
        boolean bl3 = zzji2.zzyp[n];
        zzji2.zzyp[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzji zzji2 = this;
        zzji2.zzcg();
        zzji2.zzaw(n);
        boolean bl = zzji2.zzyp[n];
        if (n < zzji2.size - 1) {
            System.arraycopy(zzji2.zzyp, n + 1, zzji2.zzyp, n, zzji2.size - n - 1);
        }
        --zzji2.size;
        ++zzji2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzji zzji2 = this;
        zzji2.zzcg();
        if (n < 0 || n > zzji2.size) {
            throw new IndexOutOfBoundsException(zzji2.zzax(n));
        }
        if (zzji2.size < zzji2.zzyp.length) {
            System.arraycopy(zzji2.zzyp, n, zzji2.zzyp, n + 1, zzji2.size - n);
        } else {
            boolean[] blArray = new boolean[zzji2.size * 3 / 2 + 1];
            System.arraycopy(zzji2.zzyp, 0, blArray, 0, n);
            System.arraycopy(zzji2.zzyp, n, blArray, n + 1, zzji2.size - n);
            zzji2.zzyp = blArray;
        }
        zzji2.zzyp[n] = bl2;
        ++zzji2.size;
        ++zzji2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Boolean bl = (Boolean)object;
        this.addBoolean(bl);
        return true;
    }

    @Override
    public final /* synthetic */ zzla zzay(int n) {
        int n2 = n;
        zzji zzji2 = this;
        if (n2 < zzji2.size) {
            throw new IllegalArgumentException();
        }
        return new zzji(Arrays.copyOf(zzji2.zzyp, n2), zzji2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzji zzji2 = this;
        zzji2.zzaw(n);
        return zzji2.zzyp[n];
    }

    static {
        zzyo.zzcf();
    }
}

