/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.awareness.fence.AwarenessFence;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.contextmanager.zzbb;
import com.google.android.gms.internal.contextmanager.zzbe;
import com.google.android.gms.internal.contextmanager.zzbi;
import com.google.android.gms.internal.contextmanager.zzbo;
import com.google.android.gms.internal.contextmanager.zzbz;
import com.google.android.gms.internal.contextmanager.zzcb;
import com.google.android.gms.internal.contextmanager.zzcd;
import com.google.android.gms.internal.contextmanager.zzce;
import com.google.android.gms.internal.contextmanager.zzdu;
import com.google.android.gms.internal.contextmanager.zzjz;
import com.google.android.gms.internal.contextmanager.zzk;
import com.google.android.gms.internal.contextmanager.zzko;
import com.google.android.gms.internal.contextmanager.zzky;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ContextFenceStubCreator")
public final class zzbl
extends AwarenessFence {
    public static final Parcelable.Creator<zzbl> CREATOR = new zzbo();
    @SafeParcelable.Field(id=2, getter="getContextFenceProtoAsBytes", type="byte[]")
    private zzdu zzbp;
    private byte[] zzbq;

    public static zzbl zzb(Collection<zzbl> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhm).zzb(zzbl.zzd(collection)).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zzc(Collection<zzbl> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhn).zzb(zzbl.zzd(collection)).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzbl zzbl2) {
        Preconditions.checkNotNull((Object)((Object)zzbl2));
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzho).zzb(zzbl2.zzs()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzce zzce2) {
        Preconditions.checkNotNull((Object)zzce2);
        zzdu.zzb zzb2 = zzce2.zzx().zzbl() ? zzdu.zzap().zzb(zzdu.zza.zzif).zzd(zzce2.zzx()) : zzdu.zzap().zzb(zzdu.zza.zzhp).zzc(zzce2.zzx());
        return new zzbl((zzdu)((zzko)zzb2.zzdn()));
    }

    public static zzbl zza(zzbz zzbz2) {
        Preconditions.checkNotNull((Object)zzbz2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhq).zzb(zzbz2.zzu()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzbb zzbb2) {
        Preconditions.checkNotNull((Object)zzbb2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhs).zzb(zzbb2.zzn()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzbe zzbe2) {
        Preconditions.checkNotNull((Object)zzbe2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhw).zzb(zzbe2.zzq()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzbi zzbi2) {
        Preconditions.checkNotNull((Object)zzbi2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzhx).zzb(zzbi2.zzr()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzcd zzcd2) {
        Preconditions.checkNotNull((Object)zzcd2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzia).zzb(zzcd2.zzw()).zzdn());
        return new zzbl(zzdu2);
    }

    public static zzbl zza(zzcb zzcb2) {
        Preconditions.checkNotNull((Object)zzcb2);
        zzdu zzdu2 = (zzdu)((zzko)zzdu.zzap().zzb(zzdu.zza.zzie).zzb(zzcb2.zzv()).zzdn());
        return new zzbl(zzdu2);
    }

    private static List<zzdu> zzd(Collection<zzbl> collection) {
        ArrayList<zzdu> arrayList = new ArrayList<zzdu>(collection.size());
        for (zzbl zzbl2 : collection) {
            arrayList.add(zzbl2.zzs());
        }
        return arrayList;
    }

    @SafeParcelable.Constructor
    public zzbl(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzbp = null;
        this.zzbq = byArray;
        this.zzt();
    }

    private zzbl(zzdu zzdu2) {
        this.zzbp = (zzdu)Preconditions.checkNotNull((Object)zzdu2);
        this.zzbq = null;
        this.zzt();
    }

    private final zzdu zzs() {
        this.zzm();
        return this.zzbp;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbl zzbl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzbl zzbl3 = zzbl2;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzbl3.zzbq != null ? zzbl3.zzbq : zzbl3.zzbp.toByteArray()), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzm();
        return this.zzbp.toString();
    }

    private final void zzm() {
        if (!(this.zzbp != null)) {
            try {
                this.zzbp = zzdu.zzc(this.zzbq, zzjz.zzcx());
                this.zzbq = null;
            }
            catch (zzky zzky2) {
                zzk.zza("ContextFenceStub", "Could not deserialize context fence bytes.", (Object)zzky2);
                throw new IllegalStateException(zzky2);
            }
        }
        this.zzt();
    }

    private final void zzt() {
        if (this.zzbp == null && this.zzbq != null) {
            return;
        }
        if (this.zzbp != null && this.zzbq == null) {
            return;
        }
        if (this.zzbp != null && this.zzbq != null) {
            throw new IllegalStateException("Invalid internal representation - full");
        }
        if (this.zzbp == null && this.zzbq == null) {
            throw new IllegalStateException("Invalid internal representation - empty");
        }
        throw new IllegalStateException("Impossible");
    }
}

