/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzja;
import com.google.android.gms.internal.contextmanager.zzkp;
import com.google.android.gms.internal.contextmanager.zzkv;
import com.google.android.gms.internal.contextmanager.zzmk;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzjd
extends zzja<Boolean>
implements zzkv<Boolean>,
zzmk,
RandomAccess {
    private static final zzjd zzzf = new zzjd(new boolean[0], 0);
    private boolean[] zzzg;
    private int size;

    zzjd() {
        this(new boolean[10], 0);
    }

    private zzjd(boolean[] blArray, int n) {
        this.zzzg = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzzg, n2, this.zzzg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzjd)) {
            return super.equals(object);
        }
        zzjd zzjd2 = (zzjd)object;
        if (this.size != zzjd2.size) {
            return false;
        }
        boolean[] blArray = zzjd2.zzzg;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzzg[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzkp.zze(this.zzzg[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzzg[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzck();
        if (this.size == this.zzzg.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzzg, 0, blArray, 0, this.size);
            this.zzzg = blArray;
        }
        this.zzzg[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzck();
        zzkp.checkNotNull(collection);
        if (!(collection instanceof zzjd)) {
            return super.addAll(collection);
        }
        zzjd zzjd2 = (zzjd)collection;
        if (zzjd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzjd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzjd2.size;
        if (n > this.zzzg.length) {
            this.zzzg = Arrays.copyOf(this.zzzg, n);
        }
        System.arraycopy(zzjd2.zzzg, 0, this.zzzg, this.size, zzjd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzzg[i])) continue;
            System.arraycopy(this.zzzg, i + 1, this.zzzg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        boolean bl = (Boolean)object;
        zzjd zzjd2 = this;
        zzjd2.zzck();
        zzjd2.zzaw(n);
        boolean bl2 = zzjd2.zzzg[n];
        zzjd2.zzzg[n] = bl;
        return bl2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzjd zzjd2 = this;
        zzjd2.zzck();
        zzjd2.zzaw(n);
        boolean bl = zzjd2.zzzg[n];
        if (n < zzjd2.size - 1) {
            System.arraycopy(zzjd2.zzzg, n + 1, zzjd2.zzzg, n, zzjd2.size - n - 1);
        }
        --zzjd2.size;
        ++zzjd2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        boolean bl = (Boolean)object;
        zzjd zzjd2 = this;
        zzjd2.zzck();
        if (n < 0 || n > zzjd2.size) {
            throw new IndexOutOfBoundsException(zzjd2.zzax(n));
        }
        if (zzjd2.size < zzjd2.zzzg.length) {
            System.arraycopy(zzjd2.zzzg, n, zzjd2.zzzg, n + 1, zzjd2.size - n);
        } else {
            boolean[] blArray = new boolean[zzjd2.size * 3 / 2 + 1];
            System.arraycopy(zzjd2.zzzg, 0, blArray, 0, n);
            System.arraycopy(zzjd2.zzzg, n, blArray, n + 1, zzjd2.size - n);
            zzjd2.zzzg = blArray;
        }
        zzjd2.zzzg[n] = bl;
        ++zzjd2.size;
        ++zzjd2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.addBoolean((Boolean)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzkv zzay(int n) {
        int n2 = n;
        zzjd zzjd2 = this;
        if (n2 < zzjd2.size) {
            throw new IllegalArgumentException();
        }
        return new zzjd(Arrays.copyOf(zzjd2.zzzg, n2), zzjd2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzjd zzjd2 = this;
        zzjd2.zzaw(n);
        return zzjd2.zzzg[n];
    }

    static {
        zzzf.zzcj();
    }
}

