/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzja;
import com.google.android.gms.internal.contextmanager.zzkp;
import com.google.android.gms.internal.contextmanager.zzkv;
import com.google.android.gms.internal.contextmanager.zzmk;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkk
extends zzja<Float>
implements zzkv<Float>,
zzmk,
RandomAccess {
    private static final zzkk zzada = new zzkk(new float[0], 0);
    private float[] zzadb;
    private int size;

    zzkk() {
        this(new float[10], 0);
    }

    private zzkk(float[] fArray, int n) {
        this.zzadb = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzadb, n2, this.zzadb, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkk)) {
            return super.equals(object);
        }
        zzkk zzkk2 = (zzkk)object;
        if (this.size != zzkk2.size) {
            return false;
        }
        float[] fArray = zzkk2.zzadb;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzadb[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzadb[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Float)) {
            return -1;
        }
        float f = ((Float)object).floatValue();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzadb[i] != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzck();
        if (this.size == this.zzadb.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzadb, 0, fArray, 0, this.size);
            this.zzadb = fArray;
        }
        this.zzadb[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzck();
        zzkp.checkNotNull(collection);
        if (!(collection instanceof zzkk)) {
            return super.addAll(collection);
        }
        zzkk zzkk2 = (zzkk)collection;
        if (zzkk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkk2.size;
        if (n > this.zzadb.length) {
            this.zzadb = Arrays.copyOf(this.zzadb, n);
        }
        System.arraycopy(zzkk2.zzadb, 0, this.zzadb, this.size, zzkk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzadb[i]))) continue;
            System.arraycopy(this.zzadb, i + 1, this.zzadb, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        float f = ((Float)object).floatValue();
        zzkk zzkk2 = this;
        zzkk2.zzck();
        zzkk2.zzaw(n);
        float f2 = zzkk2.zzadb[n];
        zzkk2.zzadb[n] = f;
        return Float.valueOf(f2);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkk zzkk2 = this;
        zzkk2.zzck();
        zzkk2.zzaw(n);
        float f = zzkk2.zzadb[n];
        if (n < zzkk2.size - 1) {
            System.arraycopy(zzkk2.zzadb, n + 1, zzkk2.zzadb, n, zzkk2.size - n - 1);
        }
        --zzkk2.size;
        ++zzkk2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        float f = ((Float)object).floatValue();
        zzkk zzkk2 = this;
        zzkk2.zzck();
        if (n < 0 || n > zzkk2.size) {
            throw new IndexOutOfBoundsException(zzkk2.zzax(n));
        }
        if (zzkk2.size < zzkk2.zzadb.length) {
            System.arraycopy(zzkk2.zzadb, n, zzkk2.zzadb, n + 1, zzkk2.size - n);
        } else {
            float[] fArray = new float[zzkk2.size * 3 / 2 + 1];
            System.arraycopy(zzkk2.zzadb, 0, fArray, 0, n);
            System.arraycopy(zzkk2.zzadb, n, fArray, n + 1, zzkk2.size - n);
            zzkk2.zzadb = fArray;
        }
        zzkk2.zzadb[n] = f;
        ++zzkk2.size;
        ++zzkk2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzc(((Float)object).floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzkv zzay(int n) {
        int n2 = n;
        zzkk zzkk2 = this;
        if (n2 < zzkk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzkk(Arrays.copyOf(zzkk2.zzadb, n2), zzkk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzkk zzkk2 = this;
        zzkk2.zzaw(n);
        return Float.valueOf(zzkk2.zzadb[n]);
    }

    static {
        zzada.zzcj();
    }
}

