/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzf<T extends IInterface> {
    private int zzaFa;
    private long zzaFb;
    private long zzaFc;
    private int zzaFd;
    private long zzaFe;
    private final Context mContext;
    private final Looper zzrs;
    private final zzn zzaFf;
    private final com.google.android.gms.common.zze zzaAQ;
    final Handler mHandler;
    private final Object zzrJ = new Object();
    private final Object zzaFg = new Object();
    private zzv zzaFh;
    protected zzf zzaFi;
    private T zzaFj;
    private final ArrayList<zze<?>> zzaFk = new ArrayList();
    private zzh zzaFl;
    private int zzaFm = 1;
    private final zzb zzaFn;
    private final zzc zzaFo;
    private final int zzaFp;
    private final String zzaFq;
    protected AtomicInteger zzaFr = new AtomicInteger(0);
    public static final String[] zzaFs = new String[]{"service_esmobile", "service_googleme"};

    protected zzf(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzn.zzaU(context), com.google.android.gms.common.zze.zzuY(), n, zzac.zzw(zzb2), zzac.zzw(zzc2), string2);
    }

    protected zzf(Context context, Looper looper, zzn zzn2, com.google.android.gms.common.zze zze2, int n, zzb zzb2, zzc zzc2, String string2) {
        this.mContext = zzac.zzb(context, (Object)"Context must not be null");
        this.zzrs = zzac.zzb(looper, (Object)"Looper must not be null");
        this.zzaFf = zzac.zzb(zzn2, (Object)"Supervisor must not be null");
        this.zzaAQ = zzac.zzb(zze2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.zzaFp = n;
        this.zzaFn = zzb2;
        this.zzaFo = zzc2;
        this.zzaFq = string2;
    }

    @NonNull
    protected abstract String zzez();

    protected String zzxv() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzeA();

    @Nullable
    protected final String zzxw() {
        return this.zzaFq == null ? this.mContext.getClass().getName() : this.zzaFq;
    }

    @Nullable
    protected abstract T zzh(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzaFc = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzaFa = n;
        this.zzaFb = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzaFd = connectionResult.getErrorCode();
        this.zzaFe = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(int n, T t) {
        zzac.zzax(n == 3 == (t != null));
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaFm = n;
            this.zzaFj = t;
            switch (n) {
                case 2: {
                    this.zzxx();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzxy();
                }
            }
        }
    }

    private void zzxx() {
        String string2;
        if (this.zzaFl != null) {
            String string3 = String.valueOf(this.zzez());
            string2 = String.valueOf(this.zzxv());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.zzaFf.zzb(this.zzez(), this.zzxv(), this.zzaFl, this.zzxw());
            this.zzaFr.incrementAndGet();
        }
        this.zzaFl = new zzh(this.zzaFr.get());
        boolean bl = this.zzaFf.zza(this.zzez(), this.zzxv(), this.zzaFl, this.zzxw());
        if (!bl) {
            string2 = String.valueOf(this.zzez());
            String string4 = String.valueOf(this.zzxv());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.zzaFr.get());
        }
    }

    private void zzxy() {
        if (this.zzaFl != null) {
            this.zzaFf.zzb(this.zzez(), this.zzxv(), this.zzaFl, this.zzxw());
            this.zzaFl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaFm != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public void zzxz() {
        int n = this.zzaAQ.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzi(), n, null);
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.zzaFi = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaFm == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaFm == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaFr.incrementAndGet();
        Object object = this.zzaFk;
        synchronized (object) {
            int n = this.zzaFk.size();
            for (int i = 0; i < n; ++i) {
                this.zzaFk.get(i).zzxI();
            }
            this.zzaFk.clear();
        }
        object = this.zzaFg;
        synchronized (object) {
            this.zzaFh = null;
        }
        this.zza(1, null);
    }

    public void zzcS(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzaFr.get(), n));
    }

    public void zza(@NonNull zzf zzf2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzaFi = zzac.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaFr.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzrs;
    }

    public Account getAccount() {
        return null;
    }

    public com.google.android.gms.common.zzc[] zzxA() {
        return new com.google.android.gms.common.zzc[0];
    }

    public final Account zzxB() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzqL() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzxC() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzuC() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzxD() throws DeadObjectException {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaFm == 4) {
                throw new DeadObjectException();
            }
            this.zzxC();
            zzac.zza(this.zzaFj != null, (Object)"Client is connected but service is null");
            return this.zzaFj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzr zzr2, Set<Scope> set) {
        Bundle bundle = this.zzqL();
        com.google.android.gms.common.internal.zzj zzj2 = new com.google.android.gms.common.internal.zzj(this.zzaFp).zzdm(this.mContext.getPackageName()).zzp(bundle);
        if (set != null) {
            zzj2.zzf(set);
        }
        if (this.zzrd()) {
            zzj2.zzf(this.zzxB()).zzb(zzr2);
        } else if (this.zzxE()) {
            zzj2.zzf(this.getAccount());
        }
        zzj2.zza(this.zzxA());
        try {
            Object object = this.zzaFg;
            synchronized (object) {
                if (this.zzaFh != null) {
                    this.zzaFh.zza(new zzg(this, this.zzaFr.get()), zzj2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzcS(1);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzaFr.get());
        }
    }

    public boolean zzrd() {
        return false;
    }

    public boolean zzxE() {
        return false;
    }

    public boolean zzvh() {
        return true;
    }

    public boolean zzrr() {
        return false;
    }

    public Intent zzrs() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzxF() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzv zzv2;
        T t;
        int n;
        Object object = this.zzrJ;
        synchronized (object) {
            n = this.zzaFm;
            t = this.zzaFj;
        }
        object = this.zzaFg;
        synchronized (object) {
            zzv2 = this.zzaFh;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzeA()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzv2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzv2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzaFc > 0L) {
            l = this.zzaFc;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaFc)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaFb > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzaFa) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzaFa));
                }
            }
            l = this.zzaFb;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaFb)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaFe > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzaFd));
            l = this.zzaFe;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaFe)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzvi() {
        Object object = this.zzaFg;
        synchronized (object) {
            if (this.zzaFh == null) {
                return null;
            }
            return this.zzaFh.asBinder();
        }
    }

    public static final class zzg
    extends zzu.zza {
        private zzf zzaFw;
        private final int zzaFx;

        public zzg(@NonNull zzf zzf2, int n) {
            this.zzaFw = zzf2;
            this.zzaFx = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzac.zzb(this.zzaFw, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzaFw.zza(n, iBinder, bundle, this.zzaFx);
            this.zzxJ();
        }

        private void zzxJ() {
            this.zzaFw = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle zzaFt;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzaFt = bundle;
        }

        protected abstract boolean zzxG();

        protected abstract void zzm(ConnectionResult var1);

        protected void zzb(Boolean bl) {
            if (bl == null) {
                zzf.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzxG()) break;
                    zzf.this.zza(1, null);
                    this.zzm(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzf.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzf.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzaFt != null) {
                        pendingIntent = (PendingIntent)this.zzaFt.getParcelable("pendingIntent");
                    }
                    this.zzm(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected /* synthetic */ void zzu(Object object) {
            this.zzb((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder zzaFy;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzaFy = iBinder;
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            if (zzf.this.zzaFo != null) {
                zzf.this.zzaFo.onConnectionFailed(connectionResult);
            }
            zzf.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzxG() {
            String string2;
            try {
                string2 = this.zzaFy.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzf.this.zzeA().equals(string2)) {
                String string3 = String.valueOf(zzf.this.zzeA());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zzf.this.zzh(this.zzaFy);
            if (t != null && zzf.this.zza(2, 3, t)) {
                Bundle bundle = zzf.this.zzuC();
                if (zzf.this.zzaFn != null) {
                    zzf.this.zzaFn.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            zzf.this.zzaFi.zzg(connectionResult);
            zzf.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzxG() {
            zzf.this.zzaFi.zzg(ConnectionResult.zzayj);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzg(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzf.this.zza(null, zzf.this.zzxF());
            } else if (zzf.this.zzaFo != null) {
                zzf.this.zzaFo.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean zzaFv;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.zzaFv = false;
        }

        protected abstract void zzu(TListener var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzxH() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.zzaFv) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                this.zzu(TListener);
            }
            zze2 = this;
            synchronized (zze2) {
                this.zzaFv = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzxI();
            ArrayList arrayList = zzf.this.zzaFk;
            synchronized (arrayList) {
                zzf.this.zzaFk.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzxI() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zzf.this.zzaFr.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zzf.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zzf.this.zzaFi.zzg(connectionResult);
                zzf.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zzf.this.zza(4, null);
                if (zzf.this.zzaFn != null) {
                    zzf.this.zzaFn.onConnectionSuspended(message.arg2);
                }
                zzf.this.onConnectionSuspended(message.arg2);
                zzf.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zzf.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzxH();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzg(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int zzaFx;

        public zzh(int n) {
            this.zzaFx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                zzf.this.zza(8, null, this.zzaFx);
                return;
            }
            Object object = zzf.this.zzaFg;
            synchronized (object) {
                zzf.this.zzaFh = zzv.zza.zzbu(iBinder);
            }
            zzf.this.zza(0, null, this.zzaFx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zzf.this.zzaFg;
            synchronized (object) {
                zzf.this.zzaFh = null;
            }
            zzf.this.mHandler.sendMessage(zzf.this.mHandler.obtainMessage(4, this.zzaFx, 1));
        }
    }
}

