/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzo;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfe;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzsA;
    @Nullable
    private zzfd zzsB;
    private boolean zzsC;
    private Object zzsD = new Object();
    @Nullable
    private zza zzsE;
    private final Context mContext;
    private long zzsF;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbr.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzsC = false;
        this.zzsF = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbr.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzsC) {
                this.finish();
            }
            this.zzsA = AdvertisingIdClient.zzd(this.mContext);
            this.zzsB = AdvertisingIdClient.zza(this.mContext, this.zzsA);
            this.zzsC = true;
            if (bl) {
                this.zzai();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzai() {
        Object object = this.zzsD;
        synchronized (object) {
            if (this.zzsE != null) {
                this.zzsE.zzsJ.countDown();
                try {
                    this.zzsE.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzsF > 0L) {
                this.zzsE = new zza(this, this.zzsF);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbr.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzsC) {
                Object object = this.zzsD;
                synchronized (object) {
                    if (this.zzsE == null || !this.zzsE.zzsK) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzsC) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbr.zzu(this.zzsA);
            zzbr.zzu(this.zzsB);
            try {
                info = new Info(this.zzsB.getId(), this.zzsB.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzai();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbr.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzsA == null) {
                return;
            }
            try {
                if (this.zzsC) {
                    com.google.android.gms.common.stats.zza.zzrT();
                    com.google.android.gms.common.zza zza2 = this.zzsA;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzsC = false;
            this.zzsB = null;
            this.zzsA = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzd(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzoU().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzrT().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    @Nullable
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        boolean bl = false;
        float f = 0.0f;
        try {
            object = zzo.getRemoteContext(context);
            if (object != null) {
                SharedPreferences sharedPreferences = object.getSharedPreferences("google_ads_flags", 0);
                bl = sharedPreferences.getBoolean("gads:ad_id_app_context:enabled", false);
                f = sharedPreferences.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
            }
        }
        catch (Exception exception) {
            Log.w((String)"AdvertisingIdClient", (String)"Error while reading from SharedPreferences ", (Throwable)exception);
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            return null;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final void zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return;
        }
        Throwable throwable2 = throwable;
        boolean bl2 = bl;
        Info info2 = info;
        Bundle bundle = new Bundle();
        bundle.putString("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            bundle.putString("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            bundle.putString("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            bundle.putString("error", throwable2.getClass().getName());
        }
        Uri.Builder builder = Uri.parse((String)"https://pagead2.googlesyndication.com/pagead/gen_204?id=gmob-apps").buildUpon();
        for (String string2 : bundle.keySet()) {
            builder.appendQueryParameter(string2, bundle.getString(string2));
        }
        String string3 = builder.build().toString();
        new com.google.android.gms.ads.identifier.zza(this, string3).start();
    }

    private static zzfd zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfe.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzsL;
        private final boolean zzsM;

        public Info(String string2, boolean bl) {
            this.zzsL = string2;
            this.zzsM = bl;
        }

        public final String getId() {
            return this.zzsL;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzsM;
        }

        public final String toString() {
            String string2 = this.zzsL;
            boolean bl = this.zzsM;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzsH;
        private long zzsI;
        CountDownLatch zzsJ;
        boolean zzsK;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzsH = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzsI = l;
            this.zzsJ = new CountDownLatch(1);
            this.zzsK = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzsH.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzsK = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzsJ.await(this.zzsI, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

