/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.stats.zza;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzai
implements ServiceConnection {
    private final Set<ServiceConnection> zzaHV;
    private int mState;
    private boolean zzaHW;
    private IBinder zzaHl;
    private final zzag zzaHX;
    private ComponentName zzaHQ;
    private /* synthetic */ zzah zzaHY;

    public zzai(zzah zzah2, zzag zzag2) {
        this.zzaHY = zzah2;
        this.zzaHX = zzag2;
        this.zzaHV = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzah.zza(this.zzaHY);
        synchronized (hashMap) {
            zzah.zzb(this.zzaHY).removeMessages(1, (Object)this.zzaHX);
            this.zzaHl = iBinder;
            this.zzaHQ = componentName;
            Iterator<ServiceConnection> iterator = this.zzaHV.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzah.zza(this.zzaHY);
        synchronized (hashMap) {
            zzah.zzb(this.zzaHY).removeMessages(1, (Object)this.zzaHX);
            this.zzaHl = null;
            this.zzaHQ = componentName;
            Iterator<ServiceConnection> iterator = this.zzaHV.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzcB(String string2) {
        this.mState = 3;
        zzah.zzd(this.zzaHY);
        this.zzaHW = zza.zza(zzah.zzc(this.zzaHY), string2, this.zzaHX.zzrA(), this, 129);
        if (this.zzaHW) {
            Message message = zzah.zzb(this.zzaHY).obtainMessage(1, (Object)this.zzaHX);
            zzah.zzb(this.zzaHY).sendMessageDelayed(message, zzah.zze(this.zzaHY));
            return;
        }
        this.mState = 2;
        try {
            zzah.zzd(this.zzaHY);
            zzai zzai2 = this;
            Context context = zzah.zzc(this.zzaHY);
            context.unbindService((ServiceConnection)zzai2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzcC(String string2) {
        zzah.zzb(this.zzaHY).removeMessages(1, (Object)this.zzaHX);
        zzah.zzd(this.zzaHY);
        zzai zzai2 = this;
        Context context = zzah.zzc(this.zzaHY);
        context.unbindService((ServiceConnection)zzai2);
        this.zzaHW = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzaHY);
        zzah.zzc(this.zzaHY);
        this.zzaHX.zzrA();
        this.zzaHV.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzaHY);
        zzah.zzc(this.zzaHY);
        this.zzaHV.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzaHW;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzaHV.contains(serviceConnection);
    }

    public final boolean zzrB() {
        return this.zzaHV.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzaHl;
    }

    public final ComponentName getComponentName() {
        return this.zzaHQ;
    }
}

