/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.ads.identifier.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfi;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzalw;
    @Nullable
    private zzfh zzalx;
    private boolean zzaly;
    private Object zzalz = new Object();
    @Nullable
    private zza zzama;
    private final Context mContext;
    private long zzamb;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbp.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzaly = false;
        this.zzamb = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbp.zzgg("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzaly) {
                this.finish();
            }
            this.zzalw = AdvertisingIdClient.zzd(this.mContext);
            this.zzalx = AdvertisingIdClient.zza(this.mContext, this.zzalw);
            this.zzaly = true;
            if (bl) {
                this.zzbi();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbi() {
        Object object = this.zzalz;
        synchronized (object) {
            if (this.zzama != null) {
                this.zzama.zzamf.countDown();
                try {
                    this.zzama.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzamb > 0L) {
                this.zzama = new zza(this, this.zzamb);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbp.zzgg("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzaly) {
                Object object = this.zzalz;
                synchronized (object) {
                    if (this.zzama == null || !this.zzama.zzamg) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzaly) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbp.zzu(this.zzalw);
            zzbp.zzu(this.zzalx);
            try {
                info = new Info(this.zzalx.getId(), this.zzalx.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbi();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbp.zzgg("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzalw == null) {
                return;
            }
            try {
                if (this.zzaly) {
                    com.google.android.gms.common.stats.zza.zzaky();
                    com.google.android.gms.common.zza zza2 = this.zzalw;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzaly = false;
            this.zzalx = null;
            this.zzalw = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzd(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzaew().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzaky().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        zzd zzd2 = new zzd(context);
        boolean bl = zzd2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f = zzd2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        if (zzd2.getBoolean("gads:ad_id_use_shared_preference:enabled", false) && (object = zzb.zze(context).getInfo()) != null) {
            return object;
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            throw throwable;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final boolean zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    private static zzfh zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfi.zzd(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzamh;
        private final boolean zzami;

        public Info(String string2, boolean bl) {
            this.zzamh = string2;
            this.zzami = bl;
        }

        public final String getId() {
            return this.zzamh;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzami;
        }

        public final String toString() {
            String string2 = this.zzamh;
            boolean bl = this.zzami;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzamd;
        private long zzame;
        CountDownLatch zzamf;
        boolean zzamg;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzamd = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzame = l;
            this.zzamf = new CountDownLatch(1);
            this.zzamg = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzamd.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzamg = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzamf.await(this.zzame, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

