/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import java.util.Arrays;

public final class Status
extends zzbcc
implements Result,
ReflectedParcelable {
    public static final Status zzfhp = new Status(0);
    public static final Status zzfhq = new Status(14);
    public static final Status zzfhr = new Status(8);
    public static final Status zzfhs = new Status(15);
    public static final Status zzfht = new Status(16);
    private static Status zzfhu = new Status(17);
    private static Status zzfhv = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzh();
    private int zzdxt;
    private final int zzezx;
    private final String zzffa;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.zzdxt = n;
        this.zzezx = n2;
        this.zzffa = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzffa;
    }

    public final boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public final boolean isSuccess() {
        return this.zzezx <= 0;
    }

    public final boolean isCanceled() {
        return this.zzezx == 16;
    }

    public final boolean isInterrupted() {
        return this.zzezx == 14;
    }

    public final int getStatusCode() {
        return this.zzezx;
    }

    public final PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdxt, this.zzezx, this.zzffa, this.mPendingIntent});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzdxt == status.zzdxt && this.zzezx == status.zzezx && zzbf.equal(this.zzffa, status.zzffa) && zzbf.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public final String zzaft() {
        if (this.zzffa != null) {
            return this.zzffa;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzezx);
    }

    public final String toString() {
        return zzbf.zzt(this).zzg("statusCode", this.zzaft()).zzg("resolution", this.mPendingIntent).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbcf.zze(parcel2);
        zzbcf.zzc(parcel2, 1, status.getStatusCode());
        zzbcf.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbcf.zza(parcel2, 3, (Parcelable)status.mPendingIntent, n, false);
        zzbcf.zzc(parcel2, 1000, status.zzdxt);
        zzbcf.zzai(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

