/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzeug;
import com.google.android.gms.internal.zzevu;
import com.google.android.gms.internal.zzevx;
import com.google.android.gms.internal.zzevy;
import com.google.android.gms.internal.zzewq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzevt
extends zzeug<Integer>
implements zzevx,
zzewq,
RandomAccess {
    private static final zzevt zzopc = new zzevt();
    private int[] zzopd;
    private int size;

    public static zzevt zzcul() {
        return zzopc;
    }

    zzevt() {
        this(new int[10], 0);
    }

    private zzevt(int[] nArray, int n) {
        this.zzopd = nArray;
        this.size = n;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzevt)) {
            return super.equals(object);
        }
        zzevt zzevt2 = (zzevt)object;
        if (this.size != zzevt2.size) {
            return false;
        }
        int[] nArray = zzevt2.zzopd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzopd[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzopd[i];
        }
        return n;
    }

    @Override
    public final zzevx zzko(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzevt(Arrays.copyOf(this.zzopd, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzkq(n);
        return this.zzopd[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzkp(int n) {
        this.zzaf(this.size, n);
    }

    private final void zzaf(int n, int n2) {
        this.zzcsd();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzkr(n));
        }
        if (this.size < this.zzopd.length) {
            System.arraycopy(this.zzopd, n, this.zzopd, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzopd, 0, nArray, 0, n);
            System.arraycopy(this.zzopd, n, nArray, n + 1, this.size - n);
            this.zzopd = nArray;
        }
        this.zzopd[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcsd();
        zzevu.zzu(collection);
        if (!(collection instanceof zzevt)) {
            return super.addAll(collection);
        }
        zzevt zzevt2 = (zzevt)collection;
        if (zzevt2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzevt2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzevt2.size;
        if (n > this.zzopd.length) {
            this.zzopd = Arrays.copyOf(this.zzopd, n);
        }
        System.arraycopy(zzevt2.zzopd, 0, this.zzopd, this.size, zzevt2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcsd();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzopd[i])) continue;
            System.arraycopy(this.zzopd, i + 1, this.zzopd, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzkq(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzkr(n));
        }
    }

    private final String zzkr(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzevt zzevt2 = this;
        zzevt2.zzcsd();
        zzevt2.zzkq(n);
        int n4 = zzevt2.zzopd[n];
        zzevt2.zzopd[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzevt zzevt2 = this;
        zzevt2.zzcsd();
        zzevt2.zzkq(n);
        int n2 = zzevt2.zzopd[n];
        System.arraycopy(zzevt2.zzopd, n + 1, zzevt2.zzopd, n, zzevt2.size - n);
        --zzevt2.size;
        ++zzevt2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzaf(n, n2);
    }

    @Override
    public final /* synthetic */ zzevy zzks(int n) {
        return this.zzko(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzopc.zzbhs();
    }
}

