/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class Status
extends zzbej
implements Result,
ReflectedParcelable {
    public static final Status zzfko = new Status(0);
    public static final Status zzfkp = new Status(14);
    public static final Status zzfkq = new Status(8);
    public static final Status zzfkr = new Status(15);
    public static final Status zzfks = new Status(16);
    public static final Status zzfkt = new Status(17);
    private static Status zzfku = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    private int zzdzm;
    private final int zzfcq;
    @Nullable
    private final String zzfhz;
    @Nullable
    private final PendingIntent zzebp;

    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this.zzdzm = n;
        this.zzfcq = n2;
        this.zzfhz = string2;
        this.zzebp = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzebp.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzfhz;
    }

    public final boolean hasResolution() {
        return this.zzebp != null;
    }

    public final boolean isSuccess() {
        return this.zzfcq <= 0;
    }

    public final boolean isCanceled() {
        return this.zzfcq == 16;
    }

    public final boolean isInterrupted() {
        return this.zzfcq == 14;
    }

    public final int getStatusCode() {
        return this.zzfcq;
    }

    public final PendingIntent getResolution() {
        return this.zzebp;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdzm, this.zzfcq, this.zzfhz, this.zzebp});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzdzm == status.zzdzm && this.zzfcq == status.zzfcq && zzbg.equal(this.zzfhz, status.zzfhz) && zzbg.equal(this.zzebp, status.zzebp);
    }

    public final String zzagk() {
        if (this.zzfhz != null) {
            return this.zzfhz;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzfcq);
    }

    public final String toString() {
        return zzbg.zzw(this).zzg("statusCode", this.zzagk()).zzg("resolution", this.zzebp).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbem.zze(parcel2);
        zzbem.zzc(parcel2, 1, status.getStatusCode());
        zzbem.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbem.zza(parcel2, 3, (Parcelable)status.zzebp, n, false);
        zzbem.zzc(parcel2, 1000, status.zzdzm);
        zzbem.zzai(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

