/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzai;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzaj
implements ServiceConnection {
    private final Set<ServiceConnection> zzfxw;
    private int mState;
    private boolean zzfxx;
    private IBinder zzfwl;
    private final zzah zzfxy;
    private ComponentName mComponentName;
    private /* synthetic */ zzai zzfxz;

    public zzaj(zzai zzai2, zzah zzah2) {
        this.zzfxz = zzai2;
        this.zzfxy = zzah2;
        this.zzfxw = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzai.zza(this.zzfxz);
        synchronized (hashMap) {
            zzai.zzb(this.zzfxz).removeMessages(1, (Object)this.zzfxy);
            this.zzfwl = iBinder;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzfxw.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzai.zza(this.zzfxz);
        synchronized (hashMap) {
            zzai.zzb(this.zzfxz).removeMessages(1, (Object)this.zzfxy);
            this.zzfwl = null;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzfxw.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzgd(String string2) {
        this.mState = 3;
        this.zzfxx = zzai.zzd(this.zzfxz).zza(zzai.zzc(this.zzfxz), string2, this.zzfxy.zzakz(), this, this.zzfxy.zzaky());
        if (this.zzfxx) {
            Message message = zzai.zzb(this.zzfxz).obtainMessage(1, (Object)this.zzfxy);
            zzai.zzb(this.zzfxz).sendMessageDelayed(message, zzai.zze(this.zzfxz));
            return;
        }
        this.mState = 2;
        try {
            zzai.zzd(this.zzfxz);
            zzaj zzaj2 = this;
            Context context = zzai.zzc(this.zzfxz);
            context.unbindService((ServiceConnection)zzaj2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzge(String string2) {
        zzai.zzb(this.zzfxz).removeMessages(1, (Object)this.zzfxy);
        zzai.zzd(this.zzfxz);
        zzaj zzaj2 = this;
        Context context = zzai.zzc(this.zzfxz);
        context.unbindService((ServiceConnection)zzaj2);
        this.zzfxx = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzfxz);
        zzai.zzc(this.zzfxz);
        this.zzfxy.zzakz();
        this.zzfxw.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzfxz);
        zzai.zzc(this.zzfxz);
        this.zzfxw.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzfxx;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzfxw.contains(serviceConnection);
    }

    public final boolean zzala() {
        return this.zzfxw.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzfwl;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }
}

