/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class Status
extends zzbgl
implements Result,
ReflectedParcelable {
    @Hide
    public static final Status zzftq = new Status(0);
    @Hide
    public static final Status zzftr = new Status(14);
    @Hide
    public static final Status zzfts = new Status(8);
    @Hide
    public static final Status zzftt = new Status(15);
    @Hide
    public static final Status zzftu = new Status(16);
    @Hide
    private static Status zzftv = new Status(17);
    @Hide
    private static Status zzftw = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    private int zzehz;
    private final int zzcc;
    @Nullable
    private final String zzfqu;
    @Nullable
    private final PendingIntent zzekd;

    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this.zzehz = n;
        this.zzcc = n2;
        this.zzfqu = string2;
        this.zzekd = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzekd.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzfqu;
    }

    public final boolean hasResolution() {
        return this.zzekd != null;
    }

    public final boolean isSuccess() {
        return this.zzcc <= 0;
    }

    public final boolean isCanceled() {
        return this.zzcc == 16;
    }

    public final boolean isInterrupted() {
        return this.zzcc == 14;
    }

    public final int getStatusCode() {
        return this.zzcc;
    }

    public final PendingIntent getResolution() {
        return this.zzekd;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzehz, this.zzcc, this.zzfqu, this.zzekd});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzehz == status.zzehz && this.zzcc == status.zzcc && zzbg.equal(this.zzfqu, status.zzfqu) && zzbg.equal(this.zzekd, status.zzekd);
    }

    @Hide
    public final String zzaif() {
        if (this.zzfqu != null) {
            return this.zzfqu;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzcc);
    }

    public final String toString() {
        return zzbg.zzx(this).zzg("statusCode", this.zzaif()).zzg("resolution", this.zzekd).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbgo.zze(parcel2);
        zzbgo.zzc(parcel2, 1, status.getStatusCode());
        zzbgo.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbgo.zza(parcel2, 3, (Parcelable)status.zzekd, n, false);
        zzbgo.zzc(parcel2, 1000, status.zzehz);
        zzbgo.zzai(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

