/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Looper;
import android.util.Log;

public final class Asserts {
    public static void checkNull(Object object) {
        if (object != null) {
            throw new IllegalArgumentException("non-null reference");
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null reference");
        }
    }

    public static void checkNotNull(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(object2));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string2, objectArray));
        }
    }

    public static void fail(Object object) {
        throw new IllegalStateException(String.valueOf(object));
    }

    public static void checkMainThread(String string2) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            String string3 = String.valueOf(Thread.currentThread());
            String string4 = String.valueOf(Looper.getMainLooper().getThread());
            Log.e((String)"Asserts", (String)new StringBuilder(57 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("checkMainThread: current thread ").append(string3).append(" IS NOT the main thread ").append(string4).append("!").toString());
            throw new IllegalStateException(string2);
        }
    }

    public static void checkNotMainThread(String string2) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            String string3 = String.valueOf(Thread.currentThread());
            String string4 = String.valueOf(Looper.getMainLooper().getThread());
            Log.e((String)"Asserts", (String)new StringBuilder(56 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("checkNotMainThread: current thread ").append(string3).append(" IS the main thread ").append(string4).append("!").toString());
            throw new IllegalStateException(string2);
        }
    }

    private Asserts() {
        throw new AssertionError((Object)"Uninstantiable");
    }
}

