/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import com.google.android.gms.common.util.UnicodeUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@VisibleForTesting
public final class JsonUtils {
    private static final Pattern zzaae = Pattern.compile("\\\\.");
    private static final Pattern zzaaf = Pattern.compile("[\\\\\"/\b\f\n\r\t]");

    private JsonUtils() {
    }

    public static String unescapeString(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = UnicodeUtils.unescape(string2);
            Matcher matcher = zzaae.matcher(string3);
            StringBuffer stringBuffer = null;
            block10: while (matcher.find()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                switch (matcher.group().charAt(1)) {
                    case '\"': {
                        matcher.appendReplacement(stringBuffer, "\"");
                        continue block10;
                    }
                    case '\\': {
                        matcher.appendReplacement(stringBuffer, "\\\\");
                        continue block10;
                    }
                    case '/': {
                        matcher.appendReplacement(stringBuffer, "/");
                        continue block10;
                    }
                    case 'b': {
                        matcher.appendReplacement(stringBuffer, "\b");
                        continue block10;
                    }
                    case 'f': {
                        matcher.appendReplacement(stringBuffer, "\f");
                        continue block10;
                    }
                    case 'n': {
                        matcher.appendReplacement(stringBuffer, "\n");
                        continue block10;
                    }
                    case 'r': {
                        matcher.appendReplacement(stringBuffer, "\r");
                        continue block10;
                    }
                    case 't': {
                        matcher.appendReplacement(stringBuffer, "\t");
                        continue block10;
                    }
                }
                throw new IllegalStateException("Found an escaped character that should never be.");
            }
            if (stringBuffer == null) {
                return string3;
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    public static String escapeString(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Matcher matcher = zzaaf.matcher(string2);
            StringBuffer stringBuffer = null;
            while (matcher.find()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                switch (matcher.group().charAt(0)) {
                    case '\"': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\"");
                        break;
                    }
                    case '\\': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\\");
                        break;
                    }
                    case '/': {
                        matcher.appendReplacement(stringBuffer, "\\\\/");
                        break;
                    }
                    case '\b': {
                        matcher.appendReplacement(stringBuffer, "\\\\b");
                        break;
                    }
                    case '\f': {
                        matcher.appendReplacement(stringBuffer, "\\\\f");
                        break;
                    }
                    case '\n': {
                        matcher.appendReplacement(stringBuffer, "\\\\n");
                        break;
                    }
                    case '\r': {
                        matcher.appendReplacement(stringBuffer, "\\\\r");
                        break;
                    }
                    case '\t': {
                        matcher.appendReplacement(stringBuffer, "\\\\t");
                    }
                }
            }
            if (stringBuffer == null) {
                return string2;
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    public static boolean areJsonStringsEquivalent(String string2, String string3) {
        if (string2 == null && string3 == null) {
            return true;
        }
        if (string2 == null || string3 == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            JSONObject jSONObject2 = new JSONObject(string3);
            return JsonUtils.areJsonValuesEquivalent(jSONObject, jSONObject2);
        }
        catch (JSONException jSONException) {
            try {
                JSONArray jSONArray = new JSONArray(string2);
                JSONArray jSONArray2 = new JSONArray(string3);
                return JsonUtils.areJsonValuesEquivalent(jSONArray, jSONArray2);
            }
            catch (JSONException jSONException2) {
                return false;
            }
        }
    }

    public static boolean areJsonValuesEquivalent(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof JSONObject && object2 instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = (JSONObject)object2;
            if (jSONObject.length() != jSONObject2.length()) {
                return false;
            }
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!jSONObject2.has(string2)) {
                    return false;
                }
                try {
                    Object object3;
                    Object object4 = jSONObject.get(string2);
                    if (JsonUtils.areJsonValuesEquivalent(object4, object3 = jSONObject2.get(string2))) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        if (object instanceof JSONArray && object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = (JSONArray)object2;
            if (jSONArray.length() != jSONArray2.length()) {
                return false;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    Object object5 = jSONArray.get(i);
                    Object object6 = jSONArray2.get(i);
                    if (JsonUtils.areJsonValuesEquivalent(object5, object6)) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        return object.equals(object2);
    }
}

