/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.R;
import com.google.android.gms.common.internal.MetadataValueReader;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.GmsVersionParser;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import java.io.InputStream;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public class GooglePlayServicesUtilLight {
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 12451000;
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_GAMES_PACKAGE = "com.google.android.play.games";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static final String GOOGLE_PLAY_STORE_URI_STRING = "http://play.google.com/store/apps/";
    public static final String GOOGLE_PLAY_STORE_GAMES_URI_STRING = "http://play.google.com/store/apps/category/GAME";
    public static final String KEY_METADATA_GOOGLE_PLAY_SERVICES_VERSION = "com.google.android.gms.version";
    public static final int MAX_ATTEMPTS_NO_SUCH_ALGORITHM = 2;
    public static final String FEATURE_SIDEWINDER = "cn.google";
    @VisibleForTesting
    public static boolean sIsTestMode = false;
    @VisibleForTesting
    public static boolean sTestIsUserBuild = false;
    public static final boolean HONOR_DEBUG_CERTIFICATES = false;
    private static boolean zzbr = false;
    @VisibleForTesting
    private static boolean zzbs = false;
    @VisibleForTesting
    static final AtomicBoolean zzbt = new AtomicBoolean();
    private static final AtomicBoolean zzbu = new AtomicBoolean();

    public static void enableUsingApkIndependentContext() {
        zzbu.set(true);
    }

    GooglePlayServicesUtilLight() {
    }

    @Deprecated
    @VisibleForTesting
    public static String getErrorString(int n) {
        return ConnectionResult.zza(n);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        return GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context, int n) {
        try {
            context.getResources().getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            Context context2 = context;
            if (!zzbu.get()) {
                int n2 = MetadataValueReader.getGooglePlayServicesVersion(context2);
                if (n2 == 0) {
                    throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
                }
                if (n2 != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                    int n3 = GOOGLE_PLAY_SERVICES_VERSION_CODE;
                    throw new IllegalStateException(new StringBuilder(320).append("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected ").append(n3).append(" but found ").append(n2).append(".  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />").toString());
                }
            }
        }
        boolean bl = !DeviceProperties.isWearableWithoutPlayStore(context) && !DeviceProperties.isIoT(context);
        return GooglePlayServicesUtilLight.zza(context, bl, n);
    }

    @VisibleForTesting
    private static int zza(Context context, boolean bl, int n) {
        int n2;
        PackageInfo packageInfo;
        Preconditions.checkArgument(n >= 0);
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo2 = null;
        if (bl) {
            try {
                packageInfo2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is missing.");
                return 9;
            }
        }
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        GoogleSignatureVerifier googleSignatureVerifier = GoogleSignatureVerifier.getInstance(context);
        if (!googleSignatureVerifier.isGooglePublicSignedPackage(packageInfo, true)) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
            return 9;
        }
        if (!(!bl || googleSignatureVerifier.isGooglePublicSignedPackage(packageInfo2, true) && packageInfo2.signatures[0].equals((Object)packageInfo.signatures[0]))) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
            return 9;
        }
        int n3 = GmsVersionParser.parseBuildVersion(packageInfo.versionCode);
        if (n3 < (n2 = GmsVersionParser.parseBuildVersion(n))) {
            int n4 = packageInfo.versionCode;
            Log.w((String)"GooglePlayServicesUtil", (String)new StringBuilder(77).append("Google Play services out of date.  Requires ").append(n).append(" but found ").append(n4).toString());
            return 2;
        }
        ApplicationInfo applicationInfo = packageInfo.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.", (Throwable)nameNotFoundException);
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void ensurePlayServicesAvailable(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        GooglePlayServicesUtilLight.ensurePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    @Deprecated
    public static void ensurePlayServicesAvailable(Context context, int n) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n2 = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, n);
        if (n2 != 0) {
            Intent intent = GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(context, n2, "e");
            Log.e((String)"GooglePlayServicesUtil", (String)new StringBuilder(57).append("GooglePlayServices not available due to error ").append(n2).toString());
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n2);
            }
            throw new GooglePlayServicesRepairableException(n2, "Google Play Services not available", intent);
        }
    }

    @Deprecated
    public static boolean isGooglePlayServicesUid(Context context, int n) {
        return UidVerifier.isGooglePlayServicesUid(context, n);
    }

    @Deprecated
    @TargetApi(value=19)
    public static boolean uidHasPackageName(Context context, int n, String string2) {
        return UidVerifier.uidHasPackageName(context, n, string2);
    }

    @Deprecated
    public static Intent getGooglePlayServicesAvailabilityRecoveryIntent(int n) {
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, n, null);
    }

    @Deprecated
    public static boolean isUserBuildDevice() {
        return DeviceProperties.isUserBuild();
    }

    public static boolean isTestKeysBuild(Context context) {
        Context context2 = context;
        if (!zzbs) {
            Context context3 = context2;
            try {
                PackageInfo packageInfo = Wrappers.packageManager(context3).getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                GoogleSignatureVerifier googleSignatureVerifier = GoogleSignatureVerifier.getInstance(context3);
                zzbr = packageInfo != null && !googleSignatureVerifier.isGooglePublicSignedPackage(packageInfo, false) && googleSignatureVerifier.isGooglePublicSignedPackage(packageInfo, true);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
            }
            finally {
                zzbs = true;
            }
        }
        return zzbr;
    }

    public static boolean honorsDebugCertificates(Context context) {
        return GooglePlayServicesUtilLight.isTestKeysBuild(context) || !GooglePlayServicesUtilLight.isUserBuildDevice();
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int n, Context context, int n2) {
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent(context, n, n2);
    }

    @Deprecated
    public static void cancelAvailabilityErrorNotifications(Context context) {
        if (zzbt.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager != null) {
                notificationManager.cancel(10436);
            }
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    @Deprecated
    public static boolean isUserRecoverableError(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
        try (InputStream inputStream = context.getContentResolver().openInputStream(uri);){
            String string2 = new Scanner(inputStream).useDelimiter("\\A").next();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    public static int getClientVersion(Context context) {
        Preconditions.checkState(true);
        return ClientLibraryUtils.getClientVersion(context, context.getPackageName());
    }

    @Deprecated
    public static int getApkVersion(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
        return packageInfo.versionCode;
    }

    @Deprecated
    @VisibleForTesting
    public static boolean isSidewinderDevice(Context context) {
        return DeviceProperties.isSidewinder(context);
    }

    @Deprecated
    public static boolean isPlayServicesPossiblyUpdating(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return GooglePlayServicesUtilLight.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    public static boolean isPlayStorePossiblyUpdating(Context context, int n) {
        if (n == 9) {
            return GooglePlayServicesUtilLight.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=21)
    static boolean isUninstalledAppPossiblyUpdating(Context context, String string2) {
        Object object;
        Object object2;
        boolean bl = string2.equals(GOOGLE_PLAY_SERVICES_PACKAGE);
        if (PlatformVersion.isAtLeastLollipop()) {
            try {
                object2 = context.getPackageManager().getPackageInstaller().getAllSessions();
            }
            catch (Exception exception) {
                return false;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                PackageInstaller.SessionInfo sessionInfo = (PackageInstaller.SessionInfo)object.next();
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        }
        object2 = context.getPackageManager();
        try {
            object = object2.getApplicationInfo(string2, 8192);
            if (bl) {
                return ((ApplicationInfo)object).enabled;
            }
            return ((ApplicationInfo)object).enabled && !GooglePlayServicesUtilLight.isRestrictedUserProfile(context);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @TargetApi(value=18)
    public static boolean isRestrictedUserProfile(Context context) {
        Bundle bundle;
        return PlatformVersion.isAtLeastJellyBeanMR2() && (bundle = ((UserManager)context.getSystemService("user")).getApplicationRestrictions(context.getPackageName())) != null && "true".equals(bundle.getString("restricted_profile"));
    }
}

