/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.common.GoogleCertificatesQuery;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.stable.zza;
import com.google.android.gms.internal.stable.zzb;
import com.google.android.gms.internal.stable.zzc;

public interface IGoogleCertificatesApi
extends IInterface {
    public IObjectWrapper getGoogleCertificates() throws RemoteException;

    public IObjectWrapper getGoogleReleaseCertificates() throws RemoteException;

    public boolean isGoogleReleaseSigned(String var1, IObjectWrapper var2) throws RemoteException;

    public boolean isGoogleSigned(String var1, IObjectWrapper var2) throws RemoteException;

    public boolean isGoogleOrPlatformSigned(GoogleCertificatesQuery var1, IObjectWrapper var2) throws RemoteException;

    public static abstract class Stub
    extends zzb
    implements IGoogleCertificatesApi {
        public Stub() {
            super("com.google.android.gms.common.internal.IGoogleCertificatesApi");
        }

        public static IGoogleCertificatesApi asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.common.internal.IGoogleCertificatesApi");
            if (iInterface instanceof IGoogleCertificatesApi) {
                return (IGoogleCertificatesApi)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        protected boolean dispatchTransaction(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1: {
                    IObjectWrapper iObjectWrapper = this.getGoogleCertificates();
                    parcel2.writeNoException();
                    zzc.zza(parcel2, iObjectWrapper);
                    break;
                }
                case 2: {
                    IObjectWrapper iObjectWrapper = this.getGoogleReleaseCertificates();
                    parcel2.writeNoException();
                    zzc.zza(parcel2, iObjectWrapper);
                    break;
                }
                case 3: {
                    String string2 = parcel.readString();
                    IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.isGoogleReleaseSigned(string2, iObjectWrapper);
                    parcel2.writeNoException();
                    zzc.zza(parcel2, bl);
                    break;
                }
                case 4: {
                    String string3 = parcel.readString();
                    IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.isGoogleSigned(string3, iObjectWrapper);
                    parcel2.writeNoException();
                    zzc.zza(parcel2, bl);
                    break;
                }
                case 5: {
                    GoogleCertificatesQuery googleCertificatesQuery = zzc.zza(parcel, GoogleCertificatesQuery.CREATOR);
                    IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.isGoogleOrPlatformSigned(googleCertificatesQuery, iObjectWrapper);
                    parcel2.writeNoException();
                    zzc.zza(parcel2, bl);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends zza
        implements IGoogleCertificatesApi {
            Proxy(IBinder iBinder) {
                super(iBinder, "com.google.android.gms.common.internal.IGoogleCertificatesApi");
            }

            @Override
            public IObjectWrapper getGoogleCertificates() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(1, parcel);
                IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface(parcel2.readStrongBinder());
                parcel2.recycle();
                return iObjectWrapper;
            }

            @Override
            public IObjectWrapper getGoogleReleaseCertificates() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(2, parcel);
                IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface(parcel2.readStrongBinder());
                parcel2.recycle();
                return iObjectWrapper;
            }

            @Override
            public boolean isGoogleReleaseSigned(String string2, IObjectWrapper iObjectWrapper) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string2);
                zzc.zza(parcel, iObjectWrapper);
                Parcel parcel2 = this.transactAndReadException(3, parcel);
                boolean bl = zzc.zza(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean isGoogleSigned(String string2, IObjectWrapper iObjectWrapper) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string2);
                zzc.zza(parcel, iObjectWrapper);
                Parcel parcel2 = this.transactAndReadException(4, parcel);
                boolean bl = zzc.zza(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean isGoogleOrPlatformSigned(GoogleCertificatesQuery googleCertificatesQuery, IObjectWrapper iObjectWrapper) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                zzc.zza(parcel, googleCertificatesQuery);
                zzc.zza(parcel, iObjectWrapper);
                Parcel parcel2 = this.transactAndReadException(5, parcel);
                boolean bl = zzc.zza(parcel2);
                parcel2.recycle();
                return bl;
            }
        }
    }
}

