/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ContentValues;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.util.ThreadUtils;

public final class Preconditions {
    @NonNull
    public static <T> T checkNotNull(@Nullable T t) {
        if (t == null) {
            throw new NullPointerException("null reference");
        }
        return t;
    }

    public static String checkNotEmpty(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Given String is empty or null");
        }
        return string2;
    }

    public static String checkNotEmpty(String string2, Object object) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return string2;
    }

    @NonNull
    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static int checkNotZero(int n, Object object) {
        if (n == 0) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return n;
    }

    public static int checkNotZero(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Given Integer is zero");
        }
        return n;
    }

    public static long checkNotZero(long l, Object object) {
        if (l == 0L) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return l;
    }

    public static long checkNotZero(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Given Long is zero");
        }
        return l;
    }

    public static void checkNotNullIfPresent(String string2, ContentValues contentValues) {
        if (contentValues.containsKey(string2) && contentValues.get(string2) == null) {
            throw new IllegalArgumentException(String.valueOf(string2).concat(" cannot be set to null"));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string2, objectArray));
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private Preconditions() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    public static void checkMainThread(String string2) {
        if (!ThreadUtils.isMainThread()) {
            throw new IllegalStateException(string2);
        }
    }

    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    public static void checkNotMainThread(String string2) {
        if (ThreadUtils.isMainThread()) {
            throw new IllegalStateException(string2);
        }
    }

    public static void checkHandlerThread(Handler handler) {
        if (Looper.myLooper() != handler.getLooper()) {
            throw new IllegalStateException("Must be called on the handler thread");
        }
    }

    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    public static int checkElementIndex(int n, int n2, String string2) {
        if (n < 0 || n >= n2) {
            String string3;
            String string4 = string2;
            if (n < 0) {
                string3 = Preconditions.format("%s (%s) must not be negative", string4, n);
            } else {
                if (n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n2).toString());
                }
                string3 = Preconditions.format("%s (%s) must be less than size (%s)", string4, n, n2);
            }
            throw new IndexOutOfBoundsException(string3);
        }
        return n;
    }

    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    public static int checkPositionIndex(int n, int n2, String string2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.zza(n, n2, string2));
        }
        return n;
    }

    private static String zza(int n, int n2, String string2) {
        if (n < 0) {
            return Preconditions.format("%s (%s) must not be negative", string2, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(26).append("negative size: ").append(n2).toString());
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", string2, n, n2);
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException(n < 0 || n > n3 ? Preconditions.zza(n, n3, "start index") : (n2 < 0 || n2 > n3 ? Preconditions.zza(n2, n3, "end index") : Preconditions.format("end index (%s) must not be less than start index (%s)", n2, n)));
        }
    }

    public static String checkTag(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Tag must not be empty or null");
        }
        if (string2.length() > 23) {
            throw new IllegalArgumentException("Tag must not be greater than 23 chars.");
        }
        return string2;
    }

    private static String format(String string2, Object ... objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 16 * objectArray.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string2.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string2.substring(n2, n));
            stringBuilder.append(objectArray[n3++]);
            n2 = n + 2;
        }
        stringBuilder.append(string2.substring(n2));
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n3++]);
            while (n3 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n3++]);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

