/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.AbstractThreadedSyncAdapter;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import com.google.android.gms.common.stats.LoggingConstants;
import com.google.android.gms.common.stats.StatisticalEventTrackerProvider;
import com.google.android.gms.common.stats.StatsEvent;

public class StatsUtils {
    public StatsUtils() {
    }

    private static boolean zza(Integer n) {
        return !n.equals(LoggingConstants.LOG_LEVEL_OFF);
    }

    public static boolean isLoggingEnabled() {
        StatisticalEventTrackerProvider.StatisticalEventTracker statisticalEventTracker = StatisticalEventTrackerProvider.getImpl();
        return statisticalEventTracker != null && statisticalEventTracker.isEnabled() && (StatsUtils.zza(statisticalEventTracker.getLogLevel(3)) || StatsUtils.zza(statisticalEventTracker.getLogLevel(2)) || StatsUtils.zza(statisticalEventTracker.getLogLevel(1)));
    }

    public static String getEventKey(Context context, Intent intent) {
        return String.valueOf((long)System.identityHashCode(context) << 32 | (long)System.identityHashCode(intent));
    }

    public static String getEventKey(PowerManager.WakeLock wakeLock, String string2) {
        String string3 = String.valueOf(String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(wakeLock)));
        String string4 = String.valueOf(TextUtils.isEmpty((CharSequence)string2) ? "" : string2);
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    public static String getEventKey(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, String string2) {
        String string3 = String.valueOf(String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(abstractThreadedSyncAdapter)));
        String string4 = String.valueOf(TextUtils.isEmpty((CharSequence)string2) ? "" : string2);
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    public static boolean isTimeOutEvent(StatsEvent statsEvent) {
        switch (statsEvent.getEventType()) {
            case 6: 
            case 9: 
            case 12: {
                return true;
            }
        }
        return false;
    }
}

