/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    private static <T> List<T> zzc(int n, boolean bl) {
        return new ArrayList(n);
    }

    @Deprecated
    public static <T> List<T> listOf() {
        return Collections.emptyList();
    }

    @Deprecated
    public static <T> List<T> listOf(T t) {
        return Collections.singletonList(t);
    }

    @Deprecated
    public static <T> List<T> listOf(T ... TArray) {
        switch (TArray.length) {
            case 0: {
                return CollectionUtils.listOf();
            }
            case 1: {
                return CollectionUtils.listOf(TArray[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public static <T> List<T> mutableListOfWithSize(int n) {
        if (n == 0) {
            return CollectionUtils.mutableListOf();
        }
        return CollectionUtils.zzc(n, true);
    }

    public static <T> List<T> mutableListOfWithSize(int n, T t) {
        List<T> list = CollectionUtils.zzc(Math.max(n, 1), true);
        list.add(t);
        return list;
    }

    public static <T> List<T> mutableListOfWithSize(int n, T t, T t2) {
        List<T> list = CollectionUtils.zzc(Math.max(n, 2), true);
        list.add(t);
        list.add(t2);
        return list;
    }

    public static <T> List<T> mutableListOfWithSize(int n, T ... TArray) {
        int n2 = Math.max(n, TArray.length);
        if (n2 == 0) {
            return CollectionUtils.mutableListOf();
        }
        if (TArray.length == 0) {
            return CollectionUtils.mutableListOfWithSize(n);
        }
        T[] TArray2 = TArray;
        if (TArray.length == n2) {
            return new ArrayList<T>(Arrays.asList(TArray2));
        }
        List<T> list = CollectionUtils.zzc(n2, true);
        list.addAll(Arrays.asList(TArray2));
        return list;
    }

    public static <T> List<T> mutableListOf() {
        return new ArrayList();
    }

    public static <T> List<T> mutableListOf(T t) {
        return CollectionUtils.mutableListOfWithSize(1, t);
    }

    public static <T> List<T> mutableListOf(T t, T t2) {
        return CollectionUtils.mutableListOfWithSize(2, t, t2);
    }

    public static <T> List<T> mutableListOf(T ... TArray) {
        if (TArray.length == 0) {
            return CollectionUtils.mutableListOf();
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    private static <T> Set<T> zzd(int n, boolean bl) {
        int n2;
        float f = bl ? 0.75f : 1.0f;
        int n3 = n2 = bl ? 128 : 256;
        if (n <= n2) {
            return new ArraySet(n);
        }
        return new HashSet(n, f);
    }

    private static <T> Set<T> zza(int n, boolean bl, T[] TArray) {
        Set<T> set = CollectionUtils.zzd(n, bl);
        Collections.addAll(set, TArray);
        return set;
    }

    @Deprecated
    public static <T> Set<T> setOf() {
        return Collections.emptySet();
    }

    @Deprecated
    public static <T> Set<T> setOf(T t) {
        return Collections.singleton(t);
    }

    @Deprecated
    public static <T> Set<T> setOf(T t, T t2) {
        Set<T> set = CollectionUtils.zzd(2, false);
        set.add(t);
        set.add(t2);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    public static <T> Set<T> setOf(T t, T t2, T t3) {
        Set<T> set = CollectionUtils.zzd(3, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    public static <T> Set<T> setOf(T t, T t2, T t3, T t4) {
        Set<T> set = CollectionUtils.zzd(4, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        set.add(t4);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    public static <T> Set<T> setOf(T ... TArray) {
        switch (TArray.length) {
            case 0: {
                return CollectionUtils.setOf();
            }
            case 1: {
                return CollectionUtils.setOf(TArray[0]);
            }
            case 2: {
                return CollectionUtils.setOf(TArray[0], TArray[1]);
            }
            case 3: {
                return CollectionUtils.setOf(TArray[0], TArray[1], TArray[2]);
            }
            case 4: {
                return CollectionUtils.setOf(TArray[0], TArray[1], TArray[2], TArray[3]);
            }
        }
        return Collections.unmodifiableSet(CollectionUtils.zza(TArray.length, false, TArray));
    }

    private static <T> Set<T> zze(int n, boolean bl) {
        float f = bl ? 0.75f : 1.0f;
        return new LinkedHashSet(n, f);
    }

    private static <T> Set<T> zzb(int n, boolean bl, T[] TArray) {
        Set<T> set = CollectionUtils.zze(n, bl);
        Collections.addAll(set, TArray);
        return set;
    }

    public static <T> Set<T> inOrderSetOf() {
        return CollectionUtils.setOf();
    }

    public static <T> Set<T> inOrderSetOf(T t) {
        return CollectionUtils.setOf(t);
    }

    public static <T> Set<T> inOrderSetOf(T t, T t2) {
        Set<T> set = CollectionUtils.zze(2, false);
        set.add(t);
        set.add(t2);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> inOrderSetOf(T t, T t2, T t3) {
        Set<T> set = CollectionUtils.zze(3, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> inOrderSetOf(T t, T t2, T t3, T t4) {
        Set<T> set = CollectionUtils.zze(4, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        set.add(t4);
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> inOrderSetOf(T ... TArray) {
        switch (TArray.length) {
            case 0: {
                return CollectionUtils.inOrderSetOf();
            }
            case 1: {
                return CollectionUtils.inOrderSetOf(TArray[0]);
            }
            case 2: {
                return CollectionUtils.inOrderSetOf(TArray[0], TArray[1]);
            }
            case 3: {
                return CollectionUtils.inOrderSetOf(TArray[0], TArray[1], TArray[2]);
            }
            case 4: {
                return CollectionUtils.inOrderSetOf(TArray[0], TArray[1], TArray[2], TArray[3]);
            }
        }
        return Collections.unmodifiableSet(CollectionUtils.zzb(TArray.length, false, TArray));
    }

    public static <T> Set<T> mutableSetOfWithSize(int n) {
        if (n == 0) {
            return CollectionUtils.mutableSetOf();
        }
        return CollectionUtils.zzd(n, true);
    }

    public static <T> Set<T> mutableSetOfWithSize(int n, T t) {
        Set<T> set = CollectionUtils.zzd(Math.max(n, 1), true);
        set.add(t);
        return set;
    }

    public static <T> Set<T> mutableSetOfWithSize(int n, T t, T t2) {
        Set<T> set = CollectionUtils.zzd(Math.max(n, 2), true);
        set.add(t);
        set.add(t2);
        return set;
    }

    public static <T> Set<T> mutableSetOfWithSize(int n, T ... TArray) {
        int n2 = Math.max(n, TArray.length);
        if (n2 == 0) {
            return CollectionUtils.mutableSetOf();
        }
        if (TArray.length == 0) {
            return CollectionUtils.mutableSetOfWithSize(n);
        }
        return CollectionUtils.zza(n2, true, TArray);
    }

    public static <T> Set<T> mutableSetOf() {
        return new ArraySet();
    }

    public static <T> Set<T> mutableSetOf(T t) {
        return CollectionUtils.mutableSetOfWithSize(1, t);
    }

    public static <T> Set<T> mutableSetOf(T t, T t2) {
        return CollectionUtils.mutableSetOfWithSize(2, t, t2);
    }

    public static <T> Set<T> mutableSetOf(T ... TArray) {
        if (TArray.length == 0) {
            return CollectionUtils.mutableSetOf();
        }
        return CollectionUtils.zza(TArray.length, true, TArray);
    }

    public static <T> Set<T> mutableInOrderSetOfWithSize(int n) {
        if (n == 0) {
            return CollectionUtils.mutableInOrderSetOf();
        }
        return CollectionUtils.zze(n, true);
    }

    public static <T> Set<T> mutableInOrderSetOfWithSize(int n, T t) {
        Set<T> set = CollectionUtils.zze(Math.max(n, 1), true);
        set.add(t);
        return set;
    }

    public static <T> Set<T> mutableInOrderSetOfWithSize(int n, T t, T t2) {
        Set<T> set = CollectionUtils.zze(Math.max(n, 2), true);
        set.add(t);
        set.add(t2);
        return set;
    }

    public static <T> Set<T> mutableInOrderSetOfWithSize(int n, T ... TArray) {
        int n2 = Math.max(n, TArray.length);
        if (n2 == 0) {
            return CollectionUtils.mutableSetOf();
        }
        if (TArray.length == 0) {
            return CollectionUtils.mutableInOrderSetOfWithSize(n);
        }
        return CollectionUtils.zzb(n2, true, TArray);
    }

    public static <T> Set<T> mutableInOrderSetOf() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> mutableInOrderSetOf(T t) {
        return CollectionUtils.mutableInOrderSetOfWithSize(1, t);
    }

    public static <T> Set<T> mutableInOrderSetOf(T t, T t2) {
        return CollectionUtils.mutableInOrderSetOfWithSize(2, t, t2);
    }

    public static <T> Set<T> mutableInOrderSetOf(T ... TArray) {
        if (TArray.length == 0) {
            return CollectionUtils.mutableInOrderSetOf();
        }
        return CollectionUtils.zzb(TArray.length, true, TArray);
    }

    private static <K, V> void zza(K[] KArray, V[] VArray) {
        if (KArray.length != VArray.length) {
            int n = KArray.length;
            int n2 = VArray.length;
            throw new IllegalArgumentException(new StringBuilder(66).append("Key and values array lengths not equal: ").append(n).append(" != ").append(n2).toString());
        }
    }

    private static <K, V> void zza(Map<K, V> map, K[] KArray, V[] VArray) {
        for (int i = 0; i < KArray.length; ++i) {
            map.put(KArray[i], VArray[i]);
        }
    }

    private static <K, V> Map<K, V> zzf(int n, boolean bl) {
        int n2;
        float f = bl ? 0.75f : 1.0f;
        int n3 = n2 = bl ? 128 : 256;
        if (n <= n2) {
            return new ArrayMap(n);
        }
        return new HashMap(n, f);
    }

    private static <K, V> Map<K, V> zza(int n, boolean bl, K[] KArray, V[] VArray) {
        Map<K, V> map = CollectionUtils.zzf(n, bl);
        CollectionUtils.zza(map, KArray, VArray);
        return map;
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        return Collections.singletonMap(k, v);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v, K k2, V v2) {
        Map<K, V> map = CollectionUtils.zzf(2, false);
        map.put(k, v);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionUtils.zzf(3, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = CollectionUtils.zzf(4, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Map<K, V> map = CollectionUtils.zzf(5, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Map<K, V> map = CollectionUtils.zzf(6, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOfKeyValueArrays(K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        switch (KArray.length) {
            case 0: {
                return CollectionUtils.mapOf();
            }
            case 1: {
                return CollectionUtils.mapOf(KArray[0], VArray[0]);
            }
        }
        return Collections.unmodifiableMap(CollectionUtils.zza(KArray.length, false, KArray, VArray));
    }

    private static <K, V> Map<K, V> zzg(int n, boolean bl) {
        float f = bl ? 0.75f : 1.0f;
        return new LinkedHashMap(n, f);
    }

    private static <K, V> Map<K, V> zzb(int n, boolean bl, K[] KArray, V[] VArray) {
        Map<K, V> map = CollectionUtils.zzg(n, bl);
        CollectionUtils.zza(map, KArray, VArray);
        return map;
    }

    public static <K, V> Map<K, V> inOrderMapOf() {
        return CollectionUtils.mapOf();
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v) {
        return CollectionUtils.mapOf(k, v);
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v, K k2, V v2) {
        Map<K, V> map = CollectionUtils.zzg(2, false);
        map.put(k, v);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionUtils.zzg(3, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = CollectionUtils.zzg(4, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Map<K, V> map = CollectionUtils.zzg(5, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> inOrderMapOf(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Map<K, V> map = CollectionUtils.zzg(6, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> inOrderMapOfKeyValueArrays(K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        int n = KArray.length;
        switch (n) {
            case 0: {
                return CollectionUtils.inOrderMapOf();
            }
            case 1: {
                return CollectionUtils.inOrderMapOf(KArray[0], VArray[0]);
            }
        }
        return Collections.unmodifiableMap(CollectionUtils.zzb(n, false, KArray, VArray));
    }

    public static <K, V> Map<K, V> mutableMapOfWithSize(int n) {
        if (n == 0) {
            return CollectionUtils.mutableMapOf();
        }
        return CollectionUtils.zzf(n, true);
    }

    public static <K, V> Map<K, V> mutableMapOfWithSize(int n, K k, V v) {
        Map<K, V> map = CollectionUtils.zzf(Math.max(n, 1), true);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> mutableMapOfWithSize(int n, K k, V v, K k2, V v2) {
        Map<K, V> map = CollectionUtils.zzf(Math.max(n, 2), true);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mutableMapOfWithSize(int n, K k, V v, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionUtils.zzf(Math.max(n, 3), true);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> mutableMapOfKeyValueArraysWithSize(int n, K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        int n2 = Math.max(n, KArray.length);
        if (n2 == 0) {
            return CollectionUtils.mutableMapOf();
        }
        if (KArray.length == 0) {
            return CollectionUtils.mutableMapOfWithSize(n);
        }
        return CollectionUtils.zza(n2, true, KArray, VArray);
    }

    public static <K, V> Map<K, V> mutableMapOf() {
        return new ArrayMap();
    }

    public static <K, V> Map<K, V> mutableMapOf(K k, V v) {
        return CollectionUtils.mutableMapOfWithSize(1, k, v);
    }

    public static <K, V> Map<K, V> mutableMapOf(K k, V v, K k2, V v2) {
        return CollectionUtils.mutableMapOfWithSize(2, k, v, k2, v2);
    }

    public static <K, V> Map<K, V> mutableMapOf(K k, V v, K k2, V v2, K k3, V v3) {
        return CollectionUtils.mutableMapOfWithSize(3, k, v, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> mutableMapOfKeyValueArrays(K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        int n = KArray.length;
        if (n == 0) {
            return CollectionUtils.mutableMapOf();
        }
        return CollectionUtils.zza(n, true, KArray, VArray);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfWithSize(int n) {
        if (n == 0) {
            return CollectionUtils.mutableInOrderMapOf();
        }
        return CollectionUtils.zzg(n, true);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfWithSize(int n, K k, V v) {
        Map<K, V> map = CollectionUtils.zzg(Math.max(n, 1), true);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfWithSize(int n, K k, V v, K k2, V v2) {
        Map<K, V> map = CollectionUtils.zzg(Math.max(n, 2), true);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfWithSize(int n, K k, V v, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionUtils.zzg(Math.max(n, 3), true);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfKeyValueArraysWithSize(int n, K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        int n2 = Math.max(n, KArray.length);
        if (n2 == 0) {
            return CollectionUtils.mutableInOrderMapOf();
        }
        if (KArray.length == 0) {
            return CollectionUtils.mutableInOrderMapOfWithSize(n2);
        }
        return CollectionUtils.zzb(n, true, KArray, VArray);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOf() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> mutableInOrderMapOf(K k, V v) {
        return CollectionUtils.mutableInOrderMapOfWithSize(1, k, v);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOf(K k, V v, K k2, V v2) {
        return CollectionUtils.mutableInOrderMapOfWithSize(2, k, v, k2, v2);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOf(K k, V v, K k2, V v2, K k3, V v3) {
        return CollectionUtils.mutableInOrderMapOfWithSize(3, k, v, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> mutableInOrderMapOfKeyValueArrays(K[] KArray, V[] VArray) {
        CollectionUtils.zza(KArray, VArray);
        int n = KArray.length;
        if (n == 0) {
            return CollectionUtils.mutableInOrderMapOf();
        }
        return CollectionUtils.zzb(n, true, KArray, VArray);
    }
}

