/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.stable.zzg;

public final class DeviceStateUtils {
    private static final IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private static long zzzw;
    private static float zzzx;

    private DeviceStateUtils() {
    }

    @VisibleForTesting
    public static synchronized void resetForTest() {
        zzzw = 0L;
        zzzx = Float.NaN;
    }

    @TargetApi(value=20)
    public static int getDeviceState(Context context) {
        if (context == null || context.getApplicationContext() == null) {
            return -1;
        }
        Intent intent = context.getApplicationContext().registerReceiver(null, filter);
        int n = intent == null ? 0 : intent.getIntExtra("plugged", 0);
        boolean bl = (7 & n) != 0;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return -1;
        }
        return (DeviceStateUtils.isInteractive(powerManager) ? 1 : 0) << 1 | (bl ? 1 : 0);
    }

    public static boolean isInteractive(Context context) {
        return DeviceStateUtils.isInteractive((PowerManager)context.getSystemService("power"));
    }

    @TargetApi(value=20)
    public static boolean isInteractive(PowerManager powerManager) {
        if (PlatformVersion.isAtLeastKitKatWatch()) {
            return powerManager.isInteractive();
        }
        return powerManager.isScreenOn();
    }

    public static synchronized float getPowerPercentage(Context context) {
        if (SystemClock.elapsedRealtime() - zzzw < 60000L && !Float.isNaN(zzzx)) {
            return zzzx;
        }
        Intent intent = context.getApplicationContext().registerReceiver(null, filter);
        if (intent != null) {
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            zzzx = (float)n / (float)n2;
        }
        zzzw = SystemClock.elapsedRealtime();
        return zzzx;
    }

    public static boolean isCallActive(Context context) {
        return ((AudioManager)context.getSystemService("audio")).getMode() == 2;
    }

    public static boolean isUserSetupComplete(Context context) {
        return Build.VERSION.SDK_INT < 23 || Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"user_setup_complete", (int)-1) == 1;
    }

    public static boolean hasConsentedNlp(Context context) {
        return zzg.getInt(context.getContentResolver(), "network_location_opt_in", -1) == 1;
    }

    static {
        zzzx = Float.NaN;
    }
}

