/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import java.util.ArrayList;

public abstract class ObjectPoolBase<T> {
    private final ArrayList<T> zzaag;
    private final int zzaah;

    public ObjectPoolBase(int n) {
        this.zzaag = new ArrayList(n);
        this.zzaah = n;
    }

    protected abstract T newObject();

    protected boolean cleanUpObject(T t) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T aquire() {
        ArrayList<T> arrayList = this.zzaag;
        synchronized (arrayList) {
            int n = this.zzaag.size();
            if (n > 0) {
                return this.zzaag.remove(n - 1);
            }
            return this.newObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean release(T t) {
        ArrayList<T> arrayList = this.zzaag;
        synchronized (arrayList) {
            int n = this.zzaag.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzaag.get(i) != t) continue;
                String string2 = String.valueOf(t);
                throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string2).length()).append("Object released already: ").append(string2).toString());
            }
            if (n < this.zzaah && this.cleanUpObject(t)) {
                this.zzaag.add(t);
                return true;
            }
            return false;
        }
    }
}

