/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;

@VisibleForTesting
@KeepForSdk
public final class SafeParcelableSerializer {
    public SafeParcelableSerializer() {
    }

    @KeepForSdk
    public static <T extends SafeParcelable> byte[] serializeToBytes(T t) {
        Parcel parcel = Parcel.obtain();
        t.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    @KeepForSdk
    public static <T extends SafeParcelable> T deserializeFromBytes(byte[] byArray, Parcelable.Creator<T> creator) {
        Preconditions.checkNotNull(creator);
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)safeParcelable;
    }

    public static <T extends SafeParcelable> void serializeIterableToBundle(Iterable<T> iterable, Bundle bundle, String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (SafeParcelable safeParcelable : iterable) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes(safeParcelable));
        }
        bundle.putSerializable(string2, arrayList);
    }

    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundle(Bundle bundle, String string2, Parcelable.Creator<T> creator) {
        ArrayList arrayList = (ArrayList)bundle.getSerializable(string2);
        if (arrayList == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            byte[] byArray = (byte[])e;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes(byArray, creator));
        }
        return arrayList2;
    }

    public static <T extends SafeParcelable> String serializeToString(T t) {
        return Base64Utils.encodeUrlSafe(SafeParcelableSerializer.serializeToBytes(t));
    }

    public static <T extends SafeParcelable> T deserializeFromString(String string2, Parcelable.Creator<T> creator) {
        return SafeParcelableSerializer.deserializeFromBytes(Base64Utils.decodeUrlSafe(string2), creator);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeToIntentExtra(T t, Intent intent, String string2) {
        intent.putExtra(string2, SafeParcelableSerializer.serializeToBytes(t));
    }

    @KeepForSdk
    public static <T extends SafeParcelable> T deserializeFromIntentExtra(Intent intent, String string2, Parcelable.Creator<T> creator) {
        byte[] byArray = intent.getByteArrayExtra(string2);
        if (byArray == null) {
            return null;
        }
        return SafeParcelableSerializer.deserializeFromBytes(byArray, creator);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtra(Iterable<T> iterable, Intent intent, String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (SafeParcelable safeParcelable : iterable) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes(safeParcelable));
        }
        intent.putExtra(string2, arrayList);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtra(Intent intent, String string2, Parcelable.Creator<T> creator) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra(string2);
        if (arrayList == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            byte[] byArray = (byte[])e;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes(byArray, creator));
        }
        return arrayList2;
    }
}

