/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzch = new Feature[0];
    @KeepForSdk
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zzci;
    private long zzcj;
    private long zzck;
    private int zzcl;
    private long zzcm;
    @VisibleForTesting
    private zzh zzcn;
    @KeepForSdk
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context mContext;
    private final Looper zzco;
    private final GmsClientSupervisor zzcp;
    private final GoogleApiAvailabilityLight zzcq;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzcr = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    private IGmsServiceBroker zzcs;
    @VisibleForTesting
    protected ConnectionProgressReportCallbacks zzct;
    @GuardedBy(value="mLock")
    private T zzcu;
    private final ArrayList<zzb<?>> zzcv = new ArrayList();
    @GuardedBy(value="mLock")
    private zze zzcw;
    @GuardedBy(value="mLock")
    private int zzcx = 1;
    private final BaseConnectionCallbacks zzcy;
    private final BaseOnConnectionFailedListener zzcz;
    private final int zzda;
    private final String zzdb;
    private ConnectionResult zzdc = null;
    private boolean zzdd = false;
    private volatile com.google.android.gms.common.internal.zza zzde = null;
    @VisibleForTesting
    protected AtomicInteger zzdf = new AtomicInteger(0);
    @KeepForSdk
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzco = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzcp = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcq = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.mHandler = new zzc(looper);
        this.zzda = n;
        this.zzcy = baseConnectionCallbacks;
        this.zzcz = baseOnConnectionFailedListener;
        this.zzdb = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzco = handler.getLooper();
        this.zzcp = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcq = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzda = n;
        this.zzcy = baseConnectionCallbacks;
        this.zzcz = baseOnConnectionFailedListener;
        this.zzdb = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @Nullable
    private final String zzl() {
        if (this.zzdb == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzdb;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(com.google.android.gms.common.internal.zza zza2) {
        this.zzde = zza2;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        com.google.android.gms.common.internal.zza zza2 = this.zzde;
        if (zza2 == null) {
            return null;
        }
        return zza2.zzdn;
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzck = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int n) {
        this.zzci = n;
        this.zzcj = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzcl = connectionResult.getErrorCode();
        this.zzcm = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzcx = n;
            this.zzcu = t;
            this.onSetConnectState(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzcw != null && baseGmsClient.zzcn != null) {
                        String string3 = baseGmsClient.zzcn.zzt();
                        string2 = baseGmsClient.zzcn.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzcp.zza(baseGmsClient.zzcn.zzt(), baseGmsClient.zzcn.getPackageName(), baseGmsClient.zzcn.zzq(), baseGmsClient.zzcw, baseGmsClient.zzl());
                        baseGmsClient.zzdf.incrementAndGet();
                    }
                    baseGmsClient.zzcw = baseGmsClient.new zze(baseGmsClient.zzdf.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    baseGmsClient.zzcn = baseGmsClient2.zzcx == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new zzh(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, 129, false) : new zzh(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, 129, baseGmsClient2.getUseDynamicLookup());
                    boolean bl = baseGmsClient.zzcn.getUseDynamicLookup();
                    String string4 = baseGmsClient.zzl();
                    zze zze2 = baseGmsClient.zzcw;
                    int n2 = baseGmsClient.zzcn.zzq();
                    String string5 = baseGmsClient.zzcn.getPackageName();
                    String string6 = baseGmsClient.zzcn.zzt();
                    if (baseGmsClient.zzcp.zza(new GmsClientSupervisor.zza(string6, string5, n2, bl), zze2, string4)) break;
                    string2 = baseGmsClient.zzcn.zzt();
                    String string7 = baseGmsClient.zzcn.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    baseGmsClient.zza(16, null, baseGmsClient.zzdf.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked(t);
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzcw == null) break;
                    baseGmsClient.zzcp.zza(baseGmsClient.zzcn.zzt(), baseGmsClient.zzcn.getPackageName(), baseGmsClient.zzcn.zzq(), baseGmsClient.zzcw, baseGmsClient.zzl());
                    baseGmsClient.zzcw = null;
                }
            }
            return;
        }
    }

    @KeepForSdk
    void onSetConnectState(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcx != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzcq.isGooglePlayServicesAvailable(this.mContext, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzct = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcx == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcx == 2 || this.zzcx == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzm() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcx == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void disconnect() {
        this.zzdf.incrementAndGet();
        Object object = this.zzcv;
        synchronized (object) {
            int n = this.zzcv.size();
            for (int i = 0; i < n; ++i) {
                this.zzcv.get(i).removeListener();
            }
            this.zzcv.clear();
        }
        object = this.zzcr;
        synchronized (object) {
            this.zzcs = null;
        }
        this.zza(1, null);
    }

    @KeepForSdk
    public void triggerConnectionSuspended(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzdf.get(), n));
    }

    private final void zzb(int n) {
        int n2;
        if (this.zzm()) {
            n2 = 5;
            this.zzdd = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzdf.get(), 16));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        this.zzct = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzdf.get(), n, (Object)pendingIntent));
    }

    @KeepForSdk
    public final Context getContext() {
        return this.mContext;
    }

    @KeepForSdk
    public final Looper getLooper() {
        return this.zzco;
    }

    @KeepForSdk
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    public Feature[] getApiFeatures() {
        return zzch;
    }

    @KeepForSdk
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    @KeepForSdk
    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzf(n, null)));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcx == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            Preconditions.checkState(this.zzcu != null, "Client is connected but service is null");
            return this.zzcu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        Object object = this.mContext.getPackageName();
        Object object2 = new GetServiceRequest(this.zzda);
        new GetServiceRequest(this.zzda).zzak = object;
        object = bundle;
        v0.zzdt = object;
        GetServiceRequest getServiceRequest = object2;
        if (set != null) {
            object = set;
            getServiceRequest.zzds = object.toArray(new Scope[object.size()]);
        }
        if (this.requiresSignIn()) {
            object2 = this;
            object = ((BaseGmsClient)object2).getAccount() != null ? ((BaseGmsClient)object2).getAccount() : new Account(DEFAULT_ACCOUNT, "com.google");
            object2 = getServiceRequest;
            getServiceRequest.zzdu = object;
            object = iAccountAccessor;
            if (object != null) {
                ((GetServiceRequest)object2).zzdr = object.asBinder();
            }
        } else if (this.requiresAccount()) {
            object = this.getAccount();
            getServiceRequest.zzdu = object;
        }
        object = zzch;
        getServiceRequest.zzdv = zzch;
        object = this.getApiFeatures();
        getServiceRequest.zzdw = object;
        try {
            Object object3 = this.zzcr;
            synchronized (object3) {
                if (this.zzcs != null) {
                    GetServiceRequest getServiceRequest2 = getServiceRequest;
                    zzd zzd2 = new zzd(this, this.zzdf.get());
                    IGmsServiceBroker iGmsServiceBroker = this.zzcs;
                    iGmsServiceBroker.getService(zzd2, getServiceRequest2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.zzdf.get());
            return;
        }
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    protected Set<Scope> getScopes() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzcx;
            t = this.zzcu;
        }
        object = this.zzcr;
        synchronized (object) {
            iGmsServiceBroker = this.zzcs;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzck > 0L) {
            l = this.zzck;
            string3 = ((DateFormat)object).format(new Date(this.zzck));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzcj > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzci) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzci));
                }
            }
            l = this.zzcj;
            string3 = ((DateFormat)object).format(new Date(this.zzcj));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzcm > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzcl));
            l = this.zzcm;
            string3 = ((DateFormat)object).format(new Date(this.zzcm));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzcr;
        synchronized (object) {
            if (this.zzcs == null) {
                return null;
            }
            return this.zzcs.asBinder();
        }
    }

    private final boolean zzn() {
        if (this.zzdd) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzcn != null) {
            return this.zzcn.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return false;
    }

    @VisibleForTesting
    public static final class zzd
    extends IGmsCallbacks.zza {
        private BaseGmsClient zzdi;
        private final int zzdj;

        public zzd(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zzdi = baseGmsClient;
            this.zzdj = n;
        }

        @Override
        @BinderThread
        public final void zza(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zzdi, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zzdi.onPostInitHandler(n, iBinder, bundle, this.zzdj);
            this.zzdi = null;
        }

        @Override
        @BinderThread
        public final void zza(int n, @NonNull IBinder iBinder, @NonNull com.google.android.gms.common.internal.zza zza2) {
            Preconditions.checkNotNull(this.zzdi, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(zza2);
            this.zzdi.zza(zza2);
            this.onPostInitComplete(n, iBinder, zza2.zzdm);
        }
    }

    private abstract class zza
    extends zzb<Boolean> {
        private final int statusCode;
        private final Bundle zzcf;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzcf = bundle;
        }

        protected abstract boolean zzj();

        @Override
        protected abstract void zza(ConnectionResult var1);

        @Override
        protected final void zzk() {
        }

        @Override
        protected final /* synthetic */ void zza(Object object) {
            Boolean bl = (Boolean)object;
            zza zza2 = this;
            if (bl == null) {
                zza2.BaseGmsClient.this.zza(1, null);
                return;
            }
            switch (zza2.statusCode) {
                case 0: {
                    if (zza2.zzj()) break;
                    zza2.BaseGmsClient.this.zza(1, null);
                    zza2.zza(new ConnectionResult(8, null));
                    return;
                }
                case 10: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    throw new IllegalStateException(String.format("A fatal developer error has occurred. Class name: %s. Start service action: %s. Service Descriptor: %s. ", zza2.getClass().getSimpleName(), zza2.BaseGmsClient.this.getStartServiceAction(), zza2.BaseGmsClient.this.getServiceDescriptor()));
                }
                default: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (zza2.zzcf != null) {
                        pendingIntent = (PendingIntent)zza2.zzcf.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                    }
                    zza2.zza(new ConnectionResult(zza2.statusCode, pendingIntent));
                }
            }
        }
    }

    protected final class zzg
    extends zza {
        private final IBinder zzdk;

        @BinderThread
        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzdk = iBinder;
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzcz != null) {
                BaseGmsClient.this.zzcz.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzj() {
            String string2;
            try {
                string2 = this.zzdk.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.zzdk);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzdc = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzcy != null) {
                    BaseGmsClient.this.zzcy.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzf
    extends zza {
        @BinderThread
        public zzf(@Nullable int n, Bundle bundle) {
            super(n, null);
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.enableLocalFallback() && BaseGmsClient.this.zzn()) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            BaseGmsClient.this.zzct.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzj() {
            BaseGmsClient.this.zzct.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzcz != null) {
                BaseGmsClient.this.zzcz.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzb<TListener> {
        private TListener zzdg;
        private boolean zzdh;

        public zzb(TListener TListener) {
            this.zzdg = TListener;
            this.zzdh = false;
        }

        protected abstract void zza(TListener var1);

        protected abstract void zzk();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzo() {
            TListener TListener;
            zzb zzb2 = this;
            synchronized (zzb2) {
                TListener = this.zzdg;
                if (this.zzdh) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zza(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzk();
                    throw runtimeException;
                }
            } else {
                this.zzk();
            }
            zzb2 = this;
            synchronized (zzb2) {
                this.zzdh = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unregister() {
            this.removeListener();
            ArrayList arrayList = BaseGmsClient.this.zzcv;
            synchronized (arrayList) {
                BaseGmsClient.this.zzcv.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener() {
            zzb zzb2 = this;
            synchronized (zzb2) {
                this.zzdg = null;
                return;
            }
        }
    }

    final class zzc
    extends zzi {
        public zzc(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.zzdf.get() != message.arg1) {
                if (zzc.zzb(message)) {
                    zzc.zza(message);
                }
                return;
            }
            if ((message.what == 1 || message.what == 7 || message.what == 4 && !BaseGmsClient.this.enableLocalFallback() || message.what == 5) && !BaseGmsClient.this.isConnecting()) {
                zzc.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzdc = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzn() && !BaseGmsClient.this.zzdd) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzdc != null ? BaseGmsClient.this.zzdc : new ConnectionResult(8);
                BaseGmsClient.this.zzct.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzdc != null ? BaseGmsClient.this.zzdc : new ConnectionResult(8);
                BaseGmsClient.this.zzct.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.zzct.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzcy != null) {
                    BaseGmsClient.this.zzcy.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                zzc.zza(message);
                return;
            }
            if (zzc.zzb(message)) {
                ((zzb)message.obj).zzo();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            zzb zzb2 = (zzb)message.obj;
            zzb2.zzk();
            zzb2.unregister();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @VisibleForTesting
    public final class zze
    implements ServiceConnection {
        private final int zzdj;

        public zze(int n) {
            this.zzdj = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            Object object = BaseGmsClient.this.zzcr;
            synchronized (object) {
                IInterface iInterface;
                IBinder iBinder2 = iBinder;
                BaseGmsClient.this.zzcs = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.common.internal.IGmsServiceBroker")) != null && iInterface instanceof IGmsServiceBroker ? (IGmsServiceBroker)iInterface : new IGmsServiceBroker.Stub.zza(iBinder2));
            }
            BaseGmsClient.this.zza(0, null, this.zzdj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzcr;
            synchronized (object) {
                BaseGmsClient.this.zzcs = null;
            }
            BaseGmsClient.this.mHandler.sendMessage(BaseGmsClient.this.mHandler.obtainMessage(6, this.zzdj, 1));
        }
    }
}

