/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzb;

@SafeParcelable.Class(creator="FeatureCreator")
@KeepForSdk
public class Feature
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Feature> CREATOR = new zzb();
    @SafeParcelable.Field(id=1, getter="getName")
    private final String name;
    @Deprecated
    @SafeParcelable.Field(id=2, getter="getOldVersion")
    private final int zzw;
    @SafeParcelable.Field(id=3, getter="getVersion", defaultValue="-1")
    private final long zzx;

    @KeepForSdk
    public Feature(String string, long l) {
        this.name = string;
        this.zzx = l;
        this.zzw = -1;
    }

    @SafeParcelable.Constructor
    public Feature(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) long l) {
        this.name = string;
        this.zzw = n;
        this.zzx = l;
    }

    @KeepForSdk
    public String getName() {
        return this.name;
    }

    @KeepForSdk
    public long getVersion() {
        if (this.zzx == -1L) {
            return this.zzw;
        }
        return this.zzx;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Feature feature = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeString(parcel2, 1, feature.getName(), false);
        SafeParcelWriter.writeInt(parcel2, 2, feature.zzw);
        SafeParcelWriter.writeLong(parcel2, 3, feature.getVersion());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            return (this.getName() != null && this.getName().equals(feature.getName()) || this.getName() == null && feature.getName() == null) && this.getVersion() == feature.getVersion();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getVersion());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.getName()).add("version", this.getVersion()).toString();
    }
}

