/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@KeepForSdk
public final class ScopeUtil {
    private ScopeUtil() {
    }

    @KeepForSdk
    public static Set<Scope> fromScopeString(Collection<String> collection) {
        Preconditions.checkNotNull(collection, "scopeStrings can't be null.");
        return ScopeUtil.fromScopeString(collection.toArray(new String[collection.size()]));
    }

    @KeepForSdk
    public static Set<Scope> fromScopeString(String ... stringArray) {
        Preconditions.checkNotNull(stringArray, "scopeStrings can't be null.");
        HashSet<Scope> hashSet = new HashSet<Scope>(stringArray.length);
        for (String string2 : stringArray) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            hashSet.add(new Scope(string2));
        }
        return hashSet;
    }

    @KeepForSdk
    public static String[] toScopeString(Scope[] scopeArray) {
        Preconditions.checkNotNull(scopeArray, "scopes can't be null.");
        String[] stringArray = new String[scopeArray.length];
        for (int i = 0; i < scopeArray.length; ++i) {
            stringArray[i] = scopeArray[i].getScopeUri();
        }
        return stringArray;
    }

    @KeepForSdk
    public static String[] toScopeString(Set<Scope> set) {
        Preconditions.checkNotNull(set, "scopes can't be null.");
        return ScopeUtil.toScopeString(set.toArray(new Scope[set.size()]));
    }
}

