/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

abstract class zzd
extends zzn {
    private int zza;

    protected zzd(byte[] byArray) {
        Preconditions.checkArgument(byArray.length == 25);
        this.zza = Arrays.hashCode(byArray);
    }

    public int hashCode() {
        return this.zza;
    }

    public boolean equals(@Nullable Object object) {
        if (object == null || !(object instanceof zzl)) {
            return false;
        }
        try {
            zzl zzl2 = (zzl)object;
            if (zzl2.zzc() != this.hashCode()) {
                return false;
            }
            IObjectWrapper iObjectWrapper = zzl2.zzb();
            if (iObjectWrapper == null) {
                return false;
            }
            byte[] byArray = (byte[])ObjectWrapper.unwrap(iObjectWrapper);
            return Arrays.equals(this.zza(), byArray);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
            return false;
        }
    }

    abstract byte[] zza();

    @Override
    public final IObjectWrapper zzb() {
        return ObjectWrapper.wrap(this.zza());
    }

    @Override
    public final int zzc() {
        return this.hashCode();
    }

    protected static byte[] zza(String string2) {
        try {
            return string2.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }
}

