/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzb;

@SafeParcelable.Class(creator="FeatureCreator")
@KeepForSdk
public class Feature
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<Feature> CREATOR = new zzb();
    @SafeParcelable.Field(id=1, getter="getName")
    private final String zza;
    @Deprecated
    @SafeParcelable.Field(id=2, getter="getOldVersion")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getVersion", defaultValue="-1")
    private final long zzc;

    @KeepForSdk
    public Feature(@RecentlyNonNull String string, @RecentlyNonNull long l) {
        this.zza = string;
        this.zzc = l;
        this.zzb = -1;
    }

    @SafeParcelable.Constructor
    public Feature(@SafeParcelable.Param(id=1) @RecentlyNonNull String string, @SafeParcelable.Param(id=2) @RecentlyNonNull int n, @SafeParcelable.Param(id=3) @RecentlyNonNull long l) {
        this.zza = string;
        this.zzb = n;
        this.zzc = l;
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getName() {
        return this.zza;
    }

    @KeepForSdk
    @RecentlyNonNull
    public long getVersion() {
        if (this.zzc == -1L) {
            return this.zzb;
        }
        return this.zzc;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, @RecentlyNonNull int n) {
        Parcel parcel2 = parcel;
        Feature feature = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeString(parcel2, 1, feature.getName(), false);
        SafeParcelWriter.writeInt(parcel2, 2, feature.zzb);
        SafeParcelWriter.writeLong(parcel2, 3, feature.getVersion());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @RecentlyNonNull
    public boolean equals(@Nullable Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            return (this.getName() != null && this.getName().equals(feature.getName()) || this.getName() == null && feature.getName() == null) && this.getVersion() == feature.getVersion();
        }
        return false;
    }

    @RecentlyNonNull
    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getVersion());
    }

    @RecentlyNonNull
    public String toString() {
        return Objects.toStringHelper(this).add("name", this.getName()).add("version", this.getVersion()).toString();
    }
}

