/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.common.zzg;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzl;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    private final Context zzb;
    private volatile String zzc;

    private GoogleSignatureVerifier(Context context) {
        this.zzb = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public static GoogleSignatureVerifier getInstance(@RecentlyNonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (GoogleSignatureVerifier.class) {
            if (zza == null) {
                com.google.android.gms.common.zzc.zza(context);
                zza = new GoogleSignatureVerifier(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public boolean isUidGoogleSigned(@RecentlyNonNull int n) {
        zzl zzl2;
        block3: {
            GoogleSignatureVerifier googleSignatureVerifier = this;
            String[] stringArray = googleSignatureVerifier.zzb.getPackageManager().getPackagesForUid(n);
            if (stringArray == null || stringArray.length == 0) {
                zzl2 = zzl.zza("no pkgs");
            } else {
                zzl zzl3 = null;
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string2 = stringArray2[i];
                    zzl3 = googleSignatureVerifier.zza(string2, false, false);
                    if (!zzl3.zza) continue;
                    zzl2 = zzl3;
                    break block3;
                }
                zzl2 = Preconditions.checkNotNull(zzl3);
            }
        }
        zzl zzl4 = zzl2;
        zzl2.zzc();
        return zzl4.zza;
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public boolean isPackageGoogleSigned(@RecentlyNonNull String string2) {
        zzl zzl2 = this.zza(string2, false, false);
        zzl2.zzc();
        return zzl2.zza;
    }

    @RecentlyNonNull
    public static boolean zza(@RecentlyNonNull PackageInfo packageInfo, @RecentlyNonNull boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (bl ? GoogleSignatureVerifier.zza(packageInfo, zzi.zza) : GoogleSignatureVerifier.zza(packageInfo, zzi.zza[0])) != null;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isGooglePublicSignedPackage(@RecentlyNonNull PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzl zza(String string2, boolean bl, boolean bl2) {
        zzl zzl2;
        zzl zzl3;
        PackageInfo packageInfo;
        if (string2 == null) {
            return zzl.zza("null pkg");
        }
        if (string2.equals(this.zzc)) {
            return zzl.zza();
        }
        try {
            packageInfo = this.zzb.getPackageManager().getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            return zzl.zza(string3.length() != 0 ? "no pkg ".concat(string3) : new String("no pkg "), nameNotFoundException);
        }
        PackageInfo packageInfo2 = packageInfo;
        boolean bl3 = GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb);
        PackageInfo packageInfo3 = packageInfo2;
        if (packageInfo3 == null) {
            zzl3 = zzl.zza("null pkg");
        } else if (packageInfo3.signatures == null || packageInfo3.signatures.length != 1) {
            zzl3 = zzl.zza("single cert required");
        } else {
            zzg zzg2 = new zzg(packageInfo3.signatures[0].toByteArray());
            String string4 = packageInfo3.packageName;
            zzl zzl4 = com.google.android.gms.common.zzc.zza(string4, zzg2, bl3, false);
            zzl3 = zzl2 = zzl4.zza && packageInfo3.applicationInfo != null && (packageInfo3.applicationInfo.flags & 2) != 0 && com.google.android.gms.common.zzc.zza((String)string4, (zzd)zzg2, (boolean)false, (boolean)true).zza ? zzl.zza("debuggable release cert app rejected") : zzl4;
        }
        if (zzl3.zza) {
            this.zzc = string2;
        }
        return zzl2;
    }

    @Nullable
    private static zzd zza(PackageInfo packageInfo, zzd ... zzdArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzg zzg2 = new zzg(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzdArray.length; ++i) {
            if (!zzdArray[i].equals(zzg2)) continue;
            return zzdArray[i];
        }
        return null;
    }
}

