/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.zzc;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@VisibleForTesting
@KeepForSdk
public final class JsonUtils {
    private static final Pattern zza = Pattern.compile("\\\\.");
    private static final Pattern zzb = Pattern.compile("[\\\\\"/\b\f\n\r\t]");

    private JsonUtils() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static String unescapeString(@RecentlyNonNull String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = zzc.zza(string2);
            Matcher matcher = zza.matcher(string3);
            StringBuffer stringBuffer = null;
            block10: while (matcher.find()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                switch (matcher.group().charAt(1)) {
                    case '\"': {
                        matcher.appendReplacement(stringBuffer, "\"");
                        continue block10;
                    }
                    case '\\': {
                        matcher.appendReplacement(stringBuffer, "\\\\");
                        continue block10;
                    }
                    case '/': {
                        matcher.appendReplacement(stringBuffer, "/");
                        continue block10;
                    }
                    case 'b': {
                        matcher.appendReplacement(stringBuffer, "\b");
                        continue block10;
                    }
                    case 'f': {
                        matcher.appendReplacement(stringBuffer, "\f");
                        continue block10;
                    }
                    case 'n': {
                        matcher.appendReplacement(stringBuffer, "\n");
                        continue block10;
                    }
                    case 'r': {
                        matcher.appendReplacement(stringBuffer, "\r");
                        continue block10;
                    }
                    case 't': {
                        matcher.appendReplacement(stringBuffer, "\t");
                        continue block10;
                    }
                }
                throw new IllegalStateException("Found an escaped character that should never be.");
            }
            if (stringBuffer == null) {
                return string3;
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    @RecentlyNullable
    @KeepForSdk
    public static String escapeString(@Nullable String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Matcher matcher = zzb.matcher(string2);
            StringBuffer stringBuffer = null;
            while (matcher.find()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                switch (matcher.group().charAt(0)) {
                    case '\"': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\"");
                        break;
                    }
                    case '\\': {
                        matcher.appendReplacement(stringBuffer, "\\\\\\\\");
                        break;
                    }
                    case '/': {
                        matcher.appendReplacement(stringBuffer, "\\\\/");
                        break;
                    }
                    case '\b': {
                        matcher.appendReplacement(stringBuffer, "\\\\b");
                        break;
                    }
                    case '\f': {
                        matcher.appendReplacement(stringBuffer, "\\\\f");
                        break;
                    }
                    case '\n': {
                        matcher.appendReplacement(stringBuffer, "\\\\n");
                        break;
                    }
                    case '\r': {
                        matcher.appendReplacement(stringBuffer, "\\\\r");
                        break;
                    }
                    case '\t': {
                        matcher.appendReplacement(stringBuffer, "\\\\t");
                    }
                }
            }
            if (stringBuffer == null) {
                return string2;
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean areJsonValuesEquivalent(@Nullable Object object, @Nullable Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof JSONObject && object2 instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = (JSONObject)object2;
            if (jSONObject.length() != jSONObject2.length()) {
                return false;
            }
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!jSONObject2.has(string2)) {
                    return false;
                }
                try {
                    Object object3;
                    Object object4 = jSONObject.get(Preconditions.checkNotNull(string2));
                    if (JsonUtils.areJsonValuesEquivalent(object4, object3 = jSONObject2.get(string2))) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        if (object instanceof JSONArray && object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = (JSONArray)object2;
            if (jSONArray.length() != jSONArray2.length()) {
                return false;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    Object object5 = jSONArray.get(i);
                    Object object6 = jSONArray2.get(i);
                    if (JsonUtils.areJsonValuesEquivalent(object5, object6)) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        return object.equals(object2);
    }
}

