/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.VisibleForTesting;

@VisibleForTesting
@KeepForSdk
public final class PlatformVersion {
    private static Boolean zza;

    private PlatformVersion() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastHoneycomb() {
        return true;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastHoneycombMR1() {
        return true;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastIceCreamSandwich() {
        return true;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastIceCreamSandwichMR1() {
        return Build.VERSION.SDK_INT >= 15;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastJellyBeanMR1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastJellyBeanMR2() {
        return Build.VERSION.SDK_INT >= 18;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastKitKat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastKitKatWatch() {
        return Build.VERSION.SDK_INT >= 20;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastLollipopMR1() {
        return Build.VERSION.SDK_INT >= 22;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastO() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastP() {
        return Build.VERSION.SDK_INT >= 28;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAtLeastR() {
        if (!PlatformVersion.isAtLeastQ()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 30 && Build.VERSION.CODENAME.equals("REL")) {
            return true;
        }
        if (!(Build.VERSION.CODENAME.length() == 1 && Build.VERSION.CODENAME.charAt(0) >= 'R' && Build.VERSION.CODENAME.charAt(0) <= 'Z')) {
            return false;
        }
        if (zza != null) {
            return zza;
        }
        try {
            zza = "google".equals(Build.BRAND) && !Build.ID.startsWith("RPP1") && !Build.ID.startsWith("RPP2") && Integer.parseInt(Build.VERSION.INCREMENTAL) >= 6301457;
        }
        catch (NumberFormatException numberFormatException) {
            zza = true;
        }
        if (!zza.booleanValue()) {
            Log.w((String)"PlatformVersion", (String)"Build version must be at least 6301457 to support R in gmscore");
        }
        return zza;
    }
}

