/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.wrappers.Wrappers;

@KeepForSdk
public final class UidVerifier {
    private UidVerifier() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isGooglePlayServicesUid(@RecentlyNonNull Context context, @RecentlyNonNull int n) {
        PackageInfo packageInfo;
        if (!UidVerifier.uidHasPackageName(context, n, "com.google.android.gms")) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo("com.google.android.gms", 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"UidVerifier", (int)3)) {
                Log.d((String)"UidVerifier", (String)"Package manager can't find google play services package, defaulting to false");
            }
            return false;
        }
        return GoogleSignatureVerifier.getInstance(context).isGooglePublicSignedPackage(packageInfo);
    }

    @TargetApi(value=19)
    @KeepForSdk
    @RecentlyNonNull
    public static boolean uidHasPackageName(@RecentlyNonNull Context context, @RecentlyNonNull int n, @RecentlyNonNull String string2) {
        return Wrappers.packageManager(context).zza(n, string2);
    }
}

