/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="ScopeCreator")
@KeepForSdk
public final class Scope
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<Scope> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getScopeUri")
    private final String zzb;

    @SafeParcelable.Constructor
    Scope(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2) {
        Preconditions.checkNotEmpty(string2, "scopeUri must not be null or empty");
        this.zza = n;
        this.zzb = string2;
    }

    public Scope(@RecentlyNonNull String string2) {
        this(1, string2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final String getScopeUri() {
        return this.zzb;
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scope)) {
            return false;
        }
        return this.zzb.equals(((Scope)object).zzb);
    }

    public final int hashCode() {
        return this.zzb.hashCode();
    }

    @RecentlyNonNull
    public final String toString() {
        return this.zzb;
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Scope scope = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, scope.zza);
        SafeParcelWriter.writeString(parcel2, 2, scope.getScopeUri(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

