/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@KeepForSdk
public final class Objects {
    @KeepForSdk
    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @KeepForSdk
    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static ToStringHelper toStringHelper(@RecentlyNonNull Object object) {
        return new ToStringHelper(object, null);
    }

    @KeepForSdk
    public static boolean checkBundlesEquality(@RecentlyNonNull Bundle bundle, @RecentlyNonNull Bundle bundle2) {
        if (bundle == null || bundle2 == null) {
            return bundle == bundle2;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        if (!set.containsAll(bundle2.keySet())) {
            return false;
        }
        for (String string2 : set) {
            if (Objects.equal(bundle.get(string2), bundle2.get(string2))) continue;
            return false;
        }
        return true;
    }

    private Objects() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    @KeepForSdk
    public static final class ToStringHelper {
        private final List<String> zza;
        private final Object zzb;

        private ToStringHelper(Object object) {
            this.zzb = Preconditions.checkNotNull(object);
            this.zza = new ArrayList<String>();
        }

        @KeepForSdk
        @RecentlyNonNull
        public final ToStringHelper add(@RecentlyNonNull String string2, @Nullable Object object) {
            String string3 = Preconditions.checkNotNull(string2);
            String string4 = String.valueOf(object);
            this.zza.add(new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append("=").append(string4).toString());
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(100).append(this.zzb.getClass().getSimpleName()).append('{');
            int n = this.zza.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.zza.get(i));
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.append('}').toString();
        }

        /* synthetic */ ToStringHelper(Object object, zzu zzu2) {
            this(object);
        }
    }
}

