/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.RecentlyNonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SafeParcelReader {
    private SafeParcelReader() {
    }

    public static int readHeader(@RecentlyNonNull Parcel parcel) {
        return parcel.readInt();
    }

    public static int getFieldId(int n) {
        return n & 0xFFFF;
    }

    public static int readSize(@RecentlyNonNull Parcel parcel, int n) {
        if ((n & 0xFFFF0000) != -65536) {
            return n >> 16 & 0xFFFF;
        }
        return parcel.readInt();
    }

    public static void skipUnknownField(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        parcel.setDataPosition(parcel.dataPosition() + n2);
    }

    private static void zza(Parcel parcel, int n, int n2) {
        int n3 = SafeParcelReader.readSize(parcel, n);
        if (n3 != n2) {
            String string2 = Integer.toHexString(n3);
            throw new ParseException(new StringBuilder(46 + String.valueOf(string2).length()).append("Expected size ").append(n2).append(" got ").append(n3).append(" (0x").append(string2).append(")").toString(), parcel);
        }
    }

    private static void zza(Parcel parcel, int n, int n2, int n3) {
        if (n2 != n3) {
            String string2 = Integer.toHexString(n2);
            throw new ParseException(new StringBuilder(46 + String.valueOf(string2).length()).append("Expected size ").append(n3).append(" got ").append(n2).append(" (0x").append(string2).append(")").toString(), parcel);
        }
    }

    public static int validateObjectHeader(@RecentlyNonNull Parcel parcel) {
        int n = SafeParcelReader.readHeader(parcel);
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (SafeParcelReader.getFieldId(n) != 20293) {
            String string2 = String.valueOf(Integer.toHexString(n));
            throw new ParseException(string2.length() != 0 ? "Expected object header. Got 0x".concat(string2) : new String("Expected object header. Got 0x"), parcel);
        }
        int n4 = n3 + n2;
        if (n4 < n3 || n4 > parcel.dataSize()) {
            throw new ParseException(new StringBuilder(54).append("Size read is invalid start=").append(n3).append(" end=").append(n4).toString(), parcel);
        }
        return n4;
    }

    public static boolean readBoolean(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt() != 0;
    }

    @RecentlyNonNull
    public static Boolean readBooleanObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return parcel.readInt() != 0;
    }

    public static byte readByte(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (byte)parcel.readInt();
    }

    public static char readChar(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (char)parcel.readInt();
    }

    public static short readShort(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (short)parcel.readInt();
    }

    public static int readInt(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt();
    }

    @RecentlyNonNull
    public static Integer readIntegerObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return parcel.readInt();
    }

    public static long readLong(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readLong();
    }

    @RecentlyNonNull
    public static Long readLongObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 8);
        return parcel.readLong();
    }

    @RecentlyNonNull
    public static BigInteger createBigInteger(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n3 + n2);
        return new BigInteger(byArray);
    }

    public static float readFloat(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readFloat();
    }

    @RecentlyNonNull
    public static Float readFloatObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return Float.valueOf(parcel.readFloat());
    }

    public static double readDouble(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readDouble();
    }

    @RecentlyNonNull
    public static Double readDoubleObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 8);
        return parcel.readDouble();
    }

    @RecentlyNonNull
    public static BigDecimal createBigDecimal(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        int n4 = parcel.readInt();
        parcel.setDataPosition(n3 + n2);
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    @RecentlyNonNull
    public static String createString(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        String string2 = parcel.readString();
        parcel.setDataPosition(n3 + n2);
        return string2;
    }

    @RecentlyNonNull
    public static IBinder readIBinder(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        IBinder iBinder = parcel.readStrongBinder();
        parcel.setDataPosition(n3 + n2);
        return iBinder;
    }

    @RecentlyNonNull
    public static PendingIntent readPendingIntent(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel((Parcel)parcel);
        parcel.setDataPosition(n3 + n2);
        return pendingIntent;
    }

    @RecentlyNonNull
    public static <T extends Parcelable> T createParcelable(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
        parcel.setDataPosition(n3 + n2);
        return (T)parcelable;
    }

    @RecentlyNonNull
    public static Bundle createBundle(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Bundle bundle = parcel.readBundle();
        parcel.setDataPosition(n3 + n2);
        return bundle;
    }

    @RecentlyNonNull
    public static byte[] createByteArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n3 + n2);
        return byArray;
    }

    @RecentlyNonNull
    public static byte[][] createByteArrayArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        byte[][] byArrayArray = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            byArrayArray[i] = parcel.createByteArray();
        }
        parcel.setDataPosition(n3 + n2);
        return byArrayArray;
    }

    @RecentlyNonNull
    public static boolean[] createBooleanArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        boolean[] blArray = parcel.createBooleanArray();
        parcel.setDataPosition(n3 + n2);
        return blArray;
    }

    @RecentlyNonNull
    public static char[] createCharArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        char[] cArray = parcel.createCharArray();
        parcel.setDataPosition(n3 + n2);
        return cArray;
    }

    @RecentlyNonNull
    public static int[] createIntArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = parcel.createIntArray();
        parcel.setDataPosition(n3 + n2);
        return nArray;
    }

    @RecentlyNonNull
    public static long[] createLongArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        long[] lArray = parcel.createLongArray();
        parcel.setDataPosition(n3 + n2);
        return lArray;
    }

    @RecentlyNonNull
    public static BigInteger[] createBigIntegerArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigInteger[] bigIntegerArray = new BigInteger[n4];
        for (int i = 0; i < n4; ++i) {
            bigIntegerArray[i] = new BigInteger(parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return bigIntegerArray;
    }

    @RecentlyNonNull
    public static float[] createFloatArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        float[] fArray = parcel.createFloatArray();
        parcel.setDataPosition(n3 + n2);
        return fArray;
    }

    @RecentlyNonNull
    public static double[] createDoubleArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        double[] dArray = parcel.createDoubleArray();
        parcel.setDataPosition(n3 + n2);
        return dArray;
    }

    @RecentlyNonNull
    public static BigDecimal[] createBigDecimalArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        for (int i = 0; i < n4; ++i) {
            byte[] byArray = parcel.createByteArray();
            int n5 = parcel.readInt();
            bigDecimalArray[i] = new BigDecimal(new BigInteger(byArray), n5);
        }
        parcel.setDataPosition(n3 + n2);
        return bigDecimalArray;
    }

    @RecentlyNonNull
    public static String[] createStringArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = parcel.createStringArray();
        parcel.setDataPosition(n3 + n2);
        return stringArray;
    }

    @RecentlyNonNull
    public static IBinder[] createIBinderArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        IBinder[] iBinderArray = parcel.createBinderArray();
        parcel.setDataPosition(n3 + n2);
        return iBinderArray;
    }

    @RecentlyNonNull
    public static ArrayList<Boolean> createBooleanList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readInt() != 0);
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<Integer> createIntegerList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static SparseBooleanArray createSparseBooleanArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = parcel.readSparseBooleanArray();
        parcel.setDataPosition(n3 + n2);
        return sparseBooleanArray;
    }

    @RecentlyNonNull
    public static SparseIntArray createSparseIntArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseIntArray sparseIntArray = new SparseIntArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            sparseIntArray.append(n5, n6);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseIntArray;
    }

    @RecentlyNonNull
    public static SparseArray<Float> createFloatSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            float f = parcel.readFloat();
            sparseArray.append(n5, (Object)Float.valueOf(f));
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<Double> createDoubleSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            double d = parcel.readDouble();
            sparseArray.append(n5, (Object)d);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseLongArray createSparseLongArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseLongArray sparseLongArray = new SparseLongArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            long l = parcel.readLong();
            sparseLongArray.append(n5, l);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseLongArray;
    }

    @RecentlyNonNull
    public static SparseArray<String> createStringSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            String string2 = parcel.readString();
            sparseArray.append(n5, (Object)string2);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<Parcel> createParcelSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            if (n6 != 0) {
                int n7 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n7, n6);
                sparseArray.append(n5, (Object)parcel2);
                parcel.setDataPosition(n7 + n6);
                continue;
            }
            sparseArray.append(n5, null);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static <T> SparseArray<T> createTypedSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            Object object = parcel.readInt() != 0 ? creator.createFromParcel(parcel) : null;
            sparseArray.append(n5, object);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<IBinder> createIBinderSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            IBinder iBinder = parcel.readStrongBinder();
            sparseArray.append(n5, (Object)iBinder);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<byte[]> createByteArraySparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            byte[] byArray = parcel.createByteArray();
            sparseArray.append(n5, (Object)byArray);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static ArrayList<Long> createLongList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<Float> createFloatList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<Double> createDoubleList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<String> createStringList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createStringArrayList();
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<IBinder> createIBinderList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createBinderArrayList();
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static <T> T[] createTypedArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = parcel.createTypedArray(creator);
        parcel.setDataPosition(n3 + n2);
        return objectArray;
    }

    @RecentlyNonNull
    public static <T> ArrayList<T> createTypedList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createTypedArrayList(creator);
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static Parcel createParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Parcel parcel2 = Parcel.obtain();
        parcel2.appendFrom(parcel, n3, n2);
        parcel.setDataPosition(n3 + n2);
        return parcel2;
    }

    @RecentlyNonNull
    public static Parcel[] createParcelArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        Parcel[] parcelArray = new Parcel[n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                parcelArray[i] = parcel2;
                parcel.setDataPosition(n6 + n5);
                continue;
            }
            parcelArray[i] = null;
        }
        parcel.setDataPosition(n3 + n2);
        return parcelArray;
    }

    @RecentlyNonNull
    public static ArrayList<Parcel> createParcelList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        ArrayList<Parcel> arrayList = new ArrayList<Parcel>();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                arrayList.add(parcel2);
                parcel.setDataPosition(n6 + n5);
                continue;
            }
            arrayList.add(null);
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static void readList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List list, @RecentlyNonNull ClassLoader classLoader) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return;
        }
        parcel.readList(list, classLoader);
        parcel.setDataPosition(n3 + n2);
    }

    public static void ensureAtEnd(@RecentlyNonNull Parcel parcel, int n) {
        if (parcel.dataPosition() != n) {
            throw new ParseException(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(@RecentlyNonNull String string2, @RecentlyNonNull Parcel parcel) {
            int n = parcel.dataPosition();
            int n2 = parcel.dataSize();
            super(new StringBuilder(41 + String.valueOf(string2).length()).append(string2).append(" Parcel: pos=").append(n).append(" size=").append(n2).toString());
        }
    }
}

