/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;

@SafeParcelable.Class(creator="StatusCreator")
@KeepForSdk
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @VisibleForTesting
    @KeepForSdk
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status RESULT_SUCCESS;
    @KeepForSdk
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status RESULT_INTERRUPTED;
    @KeepForSdk
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status RESULT_INTERNAL_ERROR;
    @KeepForSdk
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status RESULT_TIMEOUT;
    @KeepForSdk
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status RESULT_CANCELED;
    @KeepForSdk
    @RecentlyNonNull
    public static final Status RESULT_DEAD_CLIENT;
    @RecentlyNonNull
    public static final Parcelable.Creator<Status> CREATOR;
    @ShowFirstParty
    @RecentlyNonNull
    public static final Status zza;
    @SafeParcelable.VersionField(id=1000)
    final int zzb;
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zzc;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zzd;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zze;
    @SafeParcelable.Field(id=4, getter="getConnectionResult")
    @Nullable
    private final ConnectionResult zzf;

    @KeepForSdk
    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(n, n2, string2, pendingIntent, null);
    }

    @SafeParcelable.Constructor
    @KeepForSdk
    Status(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=4) @Nullable ConnectionResult connectionResult) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string2;
        this.zze = pendingIntent;
        this.zzf = connectionResult;
    }

    @KeepForSdk
    public Status(int n) {
        this(n, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public Status(@RecentlyNonNull ConnectionResult connectionResult, @RecentlyNonNull String string2) {
        this(connectionResult, string2, 17);
    }

    @Deprecated
    @KeepForSdk
    public Status(@RecentlyNonNull ConnectionResult connectionResult, @RecentlyNonNull String string2, int n) {
        this(1, n, string2, connectionResult.getResolution(), connectionResult);
    }

    public void startResolutionForResult(@RecentlyNonNull Activity activity, int n) throws IntentSender.SendIntentException {
        if (!status.hasResolution()) {
            return;
        }
        Status status = status.zze;
        Preconditions.checkNotNull(status);
        activity.startIntentSenderForResult(status.getIntentSender(), n, null, 0, 0, 0);
    }

    @RecentlyNullable
    public String getStatusMessage() {
        return this.zzd;
    }

    @RecentlyNullable
    public ConnectionResult getConnectionResult() {
        return this.zzf;
    }

    @VisibleForTesting
    public boolean hasResolution() {
        return this.zze != null;
    }

    public boolean isSuccess() {
        return this.zzc <= 0;
    }

    public boolean isCanceled() {
        return this.zzc == 16;
    }

    public boolean isInterrupted() {
        return this.zzc == 14;
    }

    public int getStatusCode() {
        return this.zzc;
    }

    @RecentlyNullable
    public PendingIntent getResolution() {
        return this.zze;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc, this.zzd, this.zze, this.zzf};
        return Objects.hashCode(objectArray);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        object = (Status)object;
        return this.zzb == ((Status)object).zzb && this.zzc == ((Status)object).zzc && Objects.equal(this.zzd, ((Status)object).zzd) && Objects.equal(this.zze, ((Status)object).zze) && Objects.equal(this.zzf, ((Status)object).zzf);
    }

    @RecentlyNonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        toStringHelper.add("statusCode", this.zza());
        toStringHelper.add("resolution", this.zze);
        return toStringHelper.toString();
    }

    @KeepForSdk
    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeInt(parcel, 1, this.getStatusCode());
        SafeParcelWriter.writeString(parcel, 2, this.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable(parcel, 3, (Parcelable)this.zze, n, false);
        SafeParcelWriter.writeParcelable(parcel, 4, this.getConnectionResult(), n, false);
        SafeParcelWriter.writeInt(parcel, 1000, this.zzb);
        SafeParcelWriter.finishObjectHeader(parcel, n2);
    }

    @Override
    @KeepForSdk
    @RecentlyNonNull
    public Status getStatus() {
        return this;
    }

    static {
        Object object = new Status(0);
        RESULT_SUCCESS = object;
        object = new Status(14);
        RESULT_INTERRUPTED = object;
        object = new Status(8);
        RESULT_INTERNAL_ERROR = object;
        object = new Status(15);
        RESULT_TIMEOUT = object;
        object = new Status(16);
        RESULT_CANCELED = object;
        object = new Status(17);
        zza = object;
        object = new Status(18);
        RESULT_DEAD_CLIENT = object;
        object = new zzb();
        CREATOR = object;
    }

    @RecentlyNonNull
    public final String zza() {
        String string2 = this.zzd;
        if (string2 != null) {
            return string2;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzc);
    }
}

