/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.util.VisibleForTesting;
import javax.annotation.concurrent.GuardedBy;

@Deprecated
@KeepForSdk
public final class GoogleServices {
    private static final Object zza;
    @GuardedBy(value="sLock")
    @Nullable
    private static GoogleServices zzb;
    @Nullable
    private final String zzc;
    private final Status zzd;
    private final boolean zze;
    private final boolean zzf;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @KeepForSdk
    GoogleServices(Context object) {
        void var1_3;
        int n;
        Resources resources = object.getResources();
        int n2 = resources.getIdentifier("google_app_measurement_enable", "integer", resources.getResourcePackageName(R.string.common_google_play_services_unknown_issue));
        if (n2 != 0) {
            n = (n2 = resources.getInteger(n2)) != 0 ? 0 : 1;
            n2 = n2 != 0 ? 1 : 0;
            this.zzf = n;
            n = n2;
        } else {
            this.zzf = false;
            n = 1;
        }
        this.zze = n;
        Object object2 = zzaf.zza(object);
        if (object2 == null) {
            object2 = new StringResourceValueReader((Context)object);
            String string2 = ((StringResourceValueReader)object2).getString("google_app_id");
        } else {
            String string3 = object2;
        }
        if (TextUtils.isEmpty((CharSequence)var1_3)) {
            Status status;
            this.zzd = status = new Status(10, "Missing google app id value from from string resources with name google_app_id.");
            this.zzc = null;
            return;
        }
        this.zzc = var1_3;
        this.zzd = Status.RESULT_SUCCESS;
    }

    @VisibleForTesting
    @KeepForSdk
    GoogleServices(String string2, boolean bl) {
        this.zzc = string2;
        this.zzd = Status.RESULT_SUCCESS;
        this.zze = bl;
        this.zzf = bl ^ true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static Status initialize(@RecentlyNonNull Context object, @RecentlyNonNull String object2, boolean bl) {
        Preconditions.checkNotNull(object, "Context must not be null.");
        Preconditions.checkNotEmpty((String)object2, "App ID must be nonempty.");
        object = zza;
        synchronized (object) {
            GoogleServices googleServices = zzb;
            if (googleServices != null) {
                return zzb.checkGoogleAppId((String)object2);
            }
            zzb = googleServices = new GoogleServices((String)object2, bl);
            return GoogleServices.zzb.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @VisibleForTesting
    @KeepForSdk
    Status checkGoogleAppId(String object) {
        String string2 = ((GoogleServices)((Object)string3)).zzc;
        if (string2 != null && !string2.equals(object)) {
            String string3 = ((GoogleServices)((Object)string3)).zzc;
            string2 = String.valueOf(string3);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 97);
            stringBuilder.append("Initialize was called with two different Google App IDs.  Only the first app ID will be used: '");
            stringBuilder.append(string3);
            stringBuilder.append("'.");
            object = new Status(10, stringBuilder.toString());
            return object;
        }
        return Status.RESULT_SUCCESS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static Status initialize(@RecentlyNonNull Context object) {
        Preconditions.checkNotNull(object, "Context must not be null.");
        Object object2 = zza;
        synchronized (object2) {
            GoogleServices googleServices = zzb;
            if (googleServices != null) return GoogleServices.zzb.zzd;
            zzb = googleServices = new GoogleServices((Context)object);
            return GoogleServices.zzb.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public static String getGoogleAppId() {
        return GoogleServices.checkInitialized((String)"getGoogleAppId").zzc;
    }

    @KeepForSdk
    public static boolean isMeasurementEnabled() {
        GoogleServices googleServices = GoogleServices.checkInitialized("isMeasurementEnabled");
        return googleServices.zzd.isSuccess() && googleServices.zze;
    }

    @KeepForSdk
    public static boolean isMeasurementExplicitlyDisabled() {
        return GoogleServices.checkInitialized((String)"isMeasurementExplicitlyDisabled").zzf;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @KeepForSdk
    static void clearInstanceForTest() {
        Object object = zza;
        synchronized (object) {
            zzb = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    private static GoogleServices checkInitialized(String object) {
        Object object2 = zza;
        synchronized (object2) {
            Object object3 = zzb;
            if (object3 != null) return zzb;
            int n = String.valueOf(object).length();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                StringBuilder stringBuilder = new StringBuilder(n += 34);
                stringBuilder.append("Initialize must be called before ");
                stringBuilder.append((String)object);
                stringBuilder.append(".");
                object3 = new IllegalStateException(stringBuilder.toString());
                throw object3;
            }
        }
    }

    static {
        Object object;
        zza = object = new Object();
    }
}

