/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.IAccountAccessor;

public class AccountAccessor
extends IAccountAccessor.Stub {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @RecentlyNullable
    public static Account getAccountBinderSafe(@RecentlyNonNull IAccountAccessor iAccountAccessor) {
        if (iAccountAccessor == null) return null;
        long l = Binder.clearCallingIdentity();
        try {
            iAccountAccessor = iAccountAccessor.zzb();
        }
        catch (RemoteException remoteException) {
            try {
                Log.w((String)"AccountAccessor", (String)"Remote account accessor probably died");
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Binder.restoreCallingIdentity((long)l);
            }
        }
        Binder.restoreCallingIdentity((long)l);
        return iAccountAccessor;
    }

    public final boolean equals(@Nullable Object object) {
        throw null;
    }

    @Override
    @RecentlyNonNull
    public final Account zzb() {
        throw null;
    }
}

