/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;

@KeepForSdk
public final class Asserts {
    @KeepForSdk
    public static void checkNull(@RecentlyNonNull Object object) {
        if (object != null) {
            object = new IllegalArgumentException("non-null reference");
            throw object;
        }
    }

    @KeepForSdk
    public static void checkNotNull(@RecentlyNonNull Object object) {
        if (object == null) {
            object = new IllegalArgumentException("null reference");
            throw object;
        }
    }

    @KeepForSdk
    public static void checkNotNull(@RecentlyNonNull Object object, @RecentlyNonNull Object object2) {
        if (object == null) {
            object = new IllegalArgumentException(String.valueOf(object2));
            throw object;
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl, @RecentlyNonNull Object object) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException(String.valueOf(object));
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkMainThread(@RecentlyNonNull String string2) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            Object object = String.valueOf(Thread.currentThread());
            String string3 = String.valueOf(Looper.getMainLooper().getThread());
            String string4 = String.valueOf(object);
            int n = string4.length();
            String string5 = String.valueOf(string3);
            int n2 = string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 57 + n2);
            stringBuilder.append("checkMainThread: current thread ");
            stringBuilder.append((String)object);
            stringBuilder.append(" IS NOT the main thread ");
            stringBuilder.append(string3);
            stringBuilder.append("!");
            Log.e((String)"Asserts", (String)stringBuilder.toString());
            object = new IllegalStateException(string2);
            throw object;
        }
    }

    @KeepForSdk
    public static void checkNotMainThread(@RecentlyNonNull String string2) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            Object object = String.valueOf(Thread.currentThread());
            String string3 = String.valueOf(Looper.getMainLooper().getThread());
            String string4 = String.valueOf(object);
            int n = string4.length();
            String string5 = String.valueOf(string3);
            int n2 = string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 56 + n2);
            stringBuilder.append("checkNotMainThread: current thread ");
            stringBuilder.append((String)object);
            stringBuilder.append(" IS the main thread ");
            stringBuilder.append(string3);
            stringBuilder.append("!");
            Log.e((String)"Asserts", (String)stringBuilder.toString());
            object = new IllegalStateException(string2);
            throw object;
        }
    }

    private Asserts() {
        Object object = new AssertionError((Object)"Uninstantiable");
        throw object;
    }
}

