/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AccountAccessor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzl;

@SafeParcelable.Reserved(value={9})
@SafeParcelable.Class(creator="GetServiceRequestCreator")
@KeepForSdk
public class GetServiceRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<GetServiceRequest> CREATOR;
    @SafeParcelable.VersionField(id=1)
    final int zza;
    @SafeParcelable.Field(id=2)
    final int zzb;
    @SafeParcelable.Field(id=3)
    int zzc;
    @SafeParcelable.Field(id=4)
    String zzd;
    @SafeParcelable.Field(id=5)
    IBinder zze;
    @SafeParcelable.Field(id=6)
    Scope[] zzf;
    @SafeParcelable.Field(id=7)
    Bundle zzg;
    @SafeParcelable.Field(id=8)
    @Nullable
    Account zzh;
    @SafeParcelable.Field(id=10)
    Feature[] zzi;
    @SafeParcelable.Field(id=11)
    Feature[] zzj;
    @SafeParcelable.Field(id=12)
    boolean zzk;
    @SafeParcelable.Field(id=13, defaultValue="0")
    int zzl;
    @SafeParcelable.Field(id=14, getter="isRequestingTelemetryConfiguration")
    boolean zzm;
    @Nullable
    @SafeParcelable.Field(id=15, getter="getAttributionTag")
    private final String zzn;

    public GetServiceRequest(int n, @Nullable String string2) {
        this.zza = 6;
        this.zzc = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        this.zzb = n;
        this.zzk = true;
        this.zzn = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    GetServiceRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) IBinder iBinder, @SafeParcelable.Param(id=6) Scope[] scopeArray, @SafeParcelable.Param(id=7) Bundle bundle, @SafeParcelable.Param(id=8) Account account, @SafeParcelable.Param(id=10) Feature[] featureArray, @SafeParcelable.Param(id=11) Feature[] featureArray2, @SafeParcelable.Param(id=12) boolean bl, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=14) boolean bl2, @Nullable @SafeParcelable.Param(id=15) String string3) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
        this.zzd = "com.google.android.gms".equals(string2) ? "com.google.android.gms" : string2;
        if (n < 2) {
            Account account2 = iBinder != null ? AccountAccessor.getAccountBinderSafe(IAccountAccessor.Stub.asInterface(iBinder)) : null;
            this.zzh = account2;
        } else {
            this.zze = iBinder;
            this.zzh = account;
        }
        this.zzf = scopeArray;
        this.zzg = bundle;
        this.zzi = featureArray;
        this.zzj = featureArray2;
        this.zzk = bl;
        this.zzl = n4;
        this.zzm = bl2;
        this.zzn = string3;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Bundle getExtraArgs() {
        return this.zzg;
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        com.google.android.gms.common.internal.zzl.zza(this, parcel, n);
    }

    static {
        zzl zzl2;
        CREATOR = zzl2 = new zzl();
    }

    @RecentlyNullable
    public final String zza() {
        return this.zzn;
    }
}

