/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@KeepForSdk
public final class Objects {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) return true;
        if (object == null) return false;
        if (!object.equals(object2)) return false;
        return true;
    }

    @KeepForSdk
    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static ToStringHelper toStringHelper(@RecentlyNonNull Object object) {
        ToStringHelper toStringHelper = new ToStringHelper(object, null);
        return toStringHelper;
    }

    @KeepForSdk
    public static boolean checkBundlesEquality(@RecentlyNonNull Bundle bundle, @RecentlyNonNull Bundle bundle2) {
        if (bundle == null || bundle2 == null) {
            return bundle == bundle2;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Object object = bundle.keySet();
        if (!object.containsAll(bundle2.keySet())) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (Objects.equal(bundle.get(string2), bundle2.get(string2))) continue;
            return false;
        }
        return true;
    }

    private Objects() {
        Object object = new AssertionError((Object)"Uninstantiable");
        throw object;
    }

    @KeepForSdk
    public static final class ToStringHelper {
        private final List<String> zza;
        private final Object zzb;

        @KeepForSdk
        @RecentlyNonNull
        public ToStringHelper add(@RecentlyNonNull String string2, @Nullable Object object) {
            List<String> list = this.zza;
            Preconditions.checkNotNull(string2);
            object = String.valueOf(object);
            int n = string2.length();
            String string3 = String.valueOf(object);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
            stringBuilder.append(string2);
            stringBuilder.append("=");
            stringBuilder.append((String)object);
            list.add(stringBuilder.toString());
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(this.zzb.getClass().getSimpleName());
            stringBuilder.append('{');
            int n = this.zza.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.zza.get(i));
                if (i >= n + -1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        /* synthetic */ ToStringHelper(Object arrayList, zzag zzag2) {
            Preconditions.checkNotNull(arrayList);
            this.zzb = arrayList;
            arrayList = new ArrayList<String>();
            this.zza = arrayList;
        }
    }
}

