/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.common.zzu;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
@KeepForSdk
public final class SafeParcelableSerializer {
    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> byte[] serializeToBytes(@RecentlyNonNull T object) {
        Parcel parcel = Parcel.obtain();
        object.writeToParcel(parcel, 0);
        object = parcel.marshall();
        parcel.recycle();
        return object;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> T deserializeFromBytes(@RecentlyNonNull byte[] object, @RecentlyNonNull Parcelable.Creator<T> creator) {
        Preconditions.checkNotNull(creator);
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(object, 0, ((byte[])object).length);
        parcel.setDataPosition(0);
        object = creator.createFromParcel(parcel);
        object = (SafeParcelable)object;
        parcel.recycle();
        return (T)object;
    }

    @Deprecated
    public static <T extends SafeParcelable> void serializeIterableToBundle(@RecentlyNonNull Iterable<T> object, @RecentlyNonNull Bundle bundle, @RecentlyNonNull String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)object.next()));
        }
        bundle.putSerializable(string2, arrayList);
    }

    @Deprecated
    @RecentlyNullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundle(@RecentlyNonNull Bundle bundle, @RecentlyNonNull String object, @RecentlyNonNull Parcelable.Creator<T> creator) {
        if ((object = (ArrayList)bundle.getSerializable((String)object)) == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(((ArrayList)object).size());
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(SafeParcelableSerializer.deserializeFromBytes((byte[])object.get(i), creator));
        }
        return arrayList;
    }

    @RecentlyNullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBytes(@Nullable byte[] object, @RecentlyNonNull Parcelable.Creator<T> creator) {
        if (object == null) {
            return null;
        }
        int n = ((byte[])object).length;
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(object, 0, n);
        parcel.setDataPosition(0);
        try {
            object = new ArrayList;
            object();
            parcel.readTypedList((List)object, creator);
        }
        finally {
            parcel.recycle();
        }
        return object;
    }

    public static <T extends SafeParcelable> void serializeIterableToBundleSafe(@RecentlyNonNull Iterable<T> iterable, @RecentlyNonNull Bundle bundle, @RecentlyNonNull String string2) {
        bundle.putByteArray(string2, SafeParcelableSerializer.zza(iterable));
    }

    @RecentlyNullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundleSafe(@RecentlyNonNull Bundle bundle, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        return SafeParcelableSerializer.deserializeIterableFromBytes(bundle.getByteArray(string2), creator);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> String serializeToString(@RecentlyNonNull T t) {
        return Base64Utils.encodeUrlSafe(SafeParcelableSerializer.serializeToBytes(t));
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> T deserializeFromString(@RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        return SafeParcelableSerializer.deserializeFromBytes(Base64Utils.decodeUrlSafe(string2), creator);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeToIntentExtra(@RecentlyNonNull T t, @RecentlyNonNull Intent intent, @RecentlyNonNull String string2) {
        intent.putExtra(string2, SafeParcelableSerializer.serializeToBytes(t));
    }

    @RecentlyNullable
    @KeepForSdk
    public static <T extends SafeParcelable> T deserializeFromIntentExtra(@RecentlyNonNull Intent object, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        if ((object = (Object)object.getByteArrayExtra(string2)) == null) {
            return null;
        }
        return SafeParcelableSerializer.deserializeFromBytes((byte[])object, creator);
    }

    @Deprecated
    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtra(@RecentlyNonNull Iterable<T> object, @RecentlyNonNull Intent intent, @RecentlyNonNull String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)object.next()));
        }
        intent.putExtra(string2, arrayList);
    }

    @Deprecated
    @RecentlyNullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtra(@RecentlyNonNull Intent intent, @RecentlyNonNull String object, @RecentlyNonNull Parcelable.Creator<T> creator) {
        if ((object = (ArrayList)intent.getSerializableExtra((String)object)) == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(((ArrayList)object).size());
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(SafeParcelableSerializer.deserializeFromBytes((byte[])object.get(i), creator));
        }
        return arrayList;
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtraSafe(@RecentlyNonNull Iterable<T> iterable, @RecentlyNonNull Intent intent, @RecentlyNonNull String string2) {
        intent.putExtra(string2, SafeParcelableSerializer.zza(iterable));
    }

    @RecentlyNullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtraSafe(@RecentlyNonNull Intent intent, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        return SafeParcelableSerializer.deserializeIterableFromBytes(intent.getByteArrayExtra(string2), creator);
    }

    private static <T extends SafeParcelable> byte[] zza(Iterable<T> object) {
        Parcel parcel = Parcel.obtain();
        try {
            parcel.writeTypedList(zzu.zzl(object));
            object = parcel.marshall();
        }
        finally {
            parcel.recycle();
        }
        return object;
    }
}

