/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.logging;

import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import java.util.Locale;

@KeepForSdk
public class Logger {
    private final String zza;
    private final String zzb;
    private final GmsLogger zzc;
    private final int zzd;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public Logger(@RecentlyNonNull String string2, String ... object) {
        int n;
        GmsLogger gmsLogger;
        void var2_5;
        int n2 = ((String[])object).length;
        if (n2 == 0) {
            String string3 = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < n2; ++i) {
                String string4 = object[i];
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string4);
            }
            stringBuilder.append("] ");
            String string5 = stringBuilder.toString();
        }
        this.zzb = var2_5;
        this.zza = string2;
        this.zzc = gmsLogger = new GmsLogger(string2);
        for (n = 2; n <= 7 && !Log.isLoggable((String)this.zza, (int)n); ++n) {
        }
        this.zzd = n;
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getTag() {
        return this.zza;
    }

    @KeepForSdk
    public boolean isLoggable(int n) {
        return this.zzd <= n;
    }

    @KeepForSdk
    public void v(@RecentlyNonNull String string2, Object ... objectArray) {
        if (this.isLoggable(2)) {
            Log.v((String)this.zza, (String)this.format(string2, objectArray));
            return;
        }
    }

    @KeepForSdk
    public void v(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable, Object ... objectArray) {
        if (this.isLoggable(2)) {
            Log.v((String)this.zza, (String)this.format(string2, objectArray), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void d(@RecentlyNonNull String string2, Object ... objectArray) {
        if (this.isLoggable(3)) {
            Log.d((String)this.zza, (String)this.format(string2, objectArray));
            return;
        }
    }

    @KeepForSdk
    public void d(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable, Object ... objectArray) {
        if (this.isLoggable(3)) {
            Log.d((String)this.zza, (String)this.format(string2, objectArray), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void i(@RecentlyNonNull String string2, Object ... objectArray) {
        Log.i((String)this.zza, (String)this.format(string2, objectArray));
    }

    @KeepForSdk
    public void w(@RecentlyNonNull String string2, Object ... objectArray) {
        Log.w((String)this.zza, (String)this.format(string2, objectArray));
    }

    @KeepForSdk
    public void e(@RecentlyNonNull String string2, Object ... objectArray) {
        Log.e((String)this.zza, (String)this.format(string2, objectArray));
    }

    @KeepForSdk
    public void e(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable, Object ... objectArray) {
        Log.e((String)this.zza, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    @KeepForSdk
    public void wtf(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable, Object ... objectArray) {
        Log.wtf((String)this.zza, (String)this.format(string2, objectArray), (Throwable)throwable);
    }

    @KeepForSdk
    public void wtf(@RecentlyNonNull Throwable throwable) {
        Log.wtf((String)this.zza, (Throwable)throwable);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected String format(@RecentlyNonNull String string2, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            string2 = String.format(Locale.US, string2, objectArray);
        }
        return this.zzb.concat(string2);
    }
}

