/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zzb;
    @Nullable
    private static volatile ConnectionTracker zzc;
    @VisibleForTesting
    @RecentlyNonNull
    public ConcurrentHashMap<ServiceConnection, ServiceConnection> zza;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static ConnectionTracker getInstance() {
        Object object;
        if (zzc == null) {
            object = zzb;
            synchronized (object) {
                ConnectionTracker connectionTracker = zzc;
                if (connectionTracker == null) {
                    zzc = connectionTracker = new ConnectionTracker();
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        object = zzc;
        Preconditions.checkNotNull(object);
        return object;
    }

    private ConnectionTracker() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.zza = concurrentHashMap;
    }

    @KeepForSdk
    public boolean bindService(@RecentlyNonNull Context context, @RecentlyNonNull Intent intent, @RecentlyNonNull ServiceConnection serviceConnection, int n) {
        return this.zzb(context, context.getClass().getName(), intent, serviceConnection, n, true);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindService(@RecentlyNonNull Context context, @RecentlyNonNull ServiceConnection serviceConnection) {
        if (ConnectionTracker.zzc(serviceConnection) && this.zza.containsKey(serviceConnection)) {
            try {
                ConnectionTracker.zzd(context, this.zza.get(serviceConnection));
                return;
            }
            finally {
                this.zza.remove(serviceConnection);
            }
        }
        ConnectionTracker.zzd(context, serviceConnection);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindServiceSafe(@RecentlyNonNull Context context, @RecentlyNonNull ServiceConnection serviceConnection) {
        try {
            this.unbindService(context, serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    static {
        Object object;
        zzb = object = new Object();
    }

    public final boolean zza(@RecentlyNonNull Context context, @RecentlyNonNull String string2, @RecentlyNonNull Intent intent, @RecentlyNonNull ServiceConnection serviceConnection, int n) {
        return this.zzb(context, string2, intent, serviceConnection, n, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SuppressLint(value={"UntrackedBindService"})
    private final boolean zzb(Context var1_2, String var2_5, Intent var3_6, ServiceConnection var4_7, int var5_8, boolean var6_9) {
        var6_10 /* !! */  = var3_6.getComponent();
        if (var6_10 /* !! */  == null) lbl-1000:
        // 3 sources

        {
            while (true) {
                if (ConnectionTracker.zzc(var4_7)) {
                    block9: {
                        var6_11 = this.zza.putIfAbsent(var4_7, var4_7);
                        if (var6_11 != null && var4_7 != var6_11) {
                            var6_11 = new Object[]{var4_7, var2_5, var3_6.getAction()};
                            Log.w((String)"ConnectionTracker", (String)String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", var6_11));
                        }
                        var1_3 = var1_2.bindService(var3_6, var4_7, var5_8);
                        if (!var1_3) break block9;
                        var0_1 = var1_3;
lbl14:
                        // 2 sources

                        return var0_1;
                    }
                    this.zza.remove(var4_7, var4_7);
                    return false;
                }
                var0_1 = var1_2.bindService(var3_6, var4_7, var5_8);
                ** continue;
                break;
            }
        }
        var6_10 /* !! */  = var6_10 /* !! */ .getPackageName();
        "com.google.android.gms".equals(var6_10 /* !! */ );
        try {
            var6_12 = Wrappers.packageManager((Context)var1_2).getApplicationInfo((String)var6_10 /* !! */ , (int)0).flags;
            if ((var6_12 & 0x200000) == 0) ** GOTO lbl-1000
        }
        catch (PackageManager.NameNotFoundException v0) {
            ** continue;
        }
        Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
        return false;
        catch (Throwable var1_4) {
            this.zza.remove(var4_7, var4_7);
            throw var1_4;
        }
    }

    private static boolean zzc(ServiceConnection serviceConnection) {
        return !(serviceConnection instanceof zzr);
    }

    @SuppressLint(value={"UntrackedBindService"})
    private static void zzd(Context context, ServiceConnection serviceConnection) {
        try {
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException runtimeException) {
            return;
        }
    }
}

