/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepForSdk
public final class CollectionUtils {
    private CollectionUtils() {
    }

    @KeepForSdk
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf() {
        return Collections.emptyList();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf(@RecentlyNonNull T t) {
        return Collections.singletonList(t);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf(T ... TArray) {
        switch (TArray.length) {
            default: {
                return Collections.unmodifiableList(Arrays.asList(TArray));
            }
            case 1: {
                return CollectionUtils.listOf(TArray[0]);
            }
            case 0: 
        }
        return CollectionUtils.listOf();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> setOf(@RecentlyNonNull T t, @RecentlyNonNull T t2, @RecentlyNonNull T t3) {
        Set<T> set = CollectionUtils.zza(3, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> setOf(T ... object) {
        int n = ((T[])object).length;
        switch (n) {
            default: {
                Set<T> set = CollectionUtils.zza(n, false);
                Collections.addAll(set, object);
                return Collections.unmodifiableSet(set);
            }
            case 0: {
                return Collections.emptySet();
            }
            case 4: {
                T t = object[0];
                T t2 = object[1];
                T t3 = object[2];
                object = object[3];
                Set<T> set = CollectionUtils.zza(4, false);
                set.add(t);
                set.add(t2);
                set.add(t3);
                set.add(object);
                return Collections.unmodifiableSet(set);
            }
            case 3: {
                return CollectionUtils.setOf(object[0], object[1], object[2]);
            }
            case 2: {
                T t = object[0];
                object = object[1];
                Set<T> set = CollectionUtils.zza(2, false);
                set.add(t);
                set.add(object);
                return Collections.unmodifiableSet(set);
            }
            case 1: 
        }
        return Collections.singleton(object[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> mutableSetOfWithSize(int n) {
        void var0_2;
        if (n == 0) {
            ArraySet arraySet = new ArraySet();
            return var0_2;
        }
        Set<T> set = CollectionUtils.zza(n, true);
        return var0_2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOf(@RecentlyNonNull K k, @RecentlyNonNull V v, @RecentlyNonNull K k2, @RecentlyNonNull V v2, @RecentlyNonNull K k3, @RecentlyNonNull V v3) {
        Map<K, V> map = CollectionUtils.zzb(3, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOf(@RecentlyNonNull K k, @RecentlyNonNull V v, @RecentlyNonNull K k2, @RecentlyNonNull V v2, @RecentlyNonNull K k3, @RecentlyNonNull V v3, @RecentlyNonNull K k4, @RecentlyNonNull V v4, @RecentlyNonNull K k5, @RecentlyNonNull V v5, @RecentlyNonNull K k6, @RecentlyNonNull V v6) {
        Map<K, V> map = CollectionUtils.zzb(6, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return Collections.unmodifiableMap(map);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOfKeyValueArrays(@RecentlyNonNull K[] object, @RecentlyNonNull V[] object2) {
        int n = ((K[])object).length;
        int n2 = ((V[])object2).length;
        if (n == n2) {
            switch (n) {
                default: {
                    Map<K, Object> map = CollectionUtils.zzb(n, false);
                    for (n = 0; n < ((K[])object).length; ++n) {
                        map.put(object[n], object2[n]);
                    }
                    return Collections.unmodifiableMap(map);
                }
                case 0: {
                    return Collections.emptyMap();
                }
                case 1: {
                    return Collections.singletonMap(object[0], object2[0]);
                }
            }
        }
        object2 = new StringBuilder(66);
        ((StringBuilder)object2).append("Key and values array lengths not equal: ");
        ((StringBuilder)object2).append(n);
        ((StringBuilder)object2).append(" != ");
        ((StringBuilder)object2).append(n2);
        object = new IllegalArgumentException(((StringBuilder)object2).toString());
        throw object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static <T> Set<T> zza(int n, boolean n2) {
        HashSet hashSet;
        void var0_2;
        int n3;
        float f = 1 != n3 ? 1.0f : 0.75f;
        if (n <= (n3 = 1 != n3 ? 256 : 128)) {
            ArraySet arraySet;
            ArraySet arraySet2 = arraySet = new ArraySet(n);
            return var0_2;
        }
        HashSet hashSet2 = hashSet = new HashSet(n, f);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <K, V> Map<K, V> zzb(int n, boolean bl) {
        HashMap hashMap;
        void var0_2;
        if (n <= 256) {
            ArrayMap arrayMap;
            ArrayMap arrayMap2 = arrayMap = new ArrayMap(n);
            return var0_2;
        }
        HashMap hashMap2 = hashMap = new HashMap(n, 1.0f);
        return var0_2;
    }
}

