/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.database.CharArrayBuffer;
import android.graphics.Bitmap;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

@KeepForSdk
public final class DataUtils {
    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static void copyStringToBuffer(@Nullable String string2, @RecentlyNonNull CharArrayBuffer charArrayBuffer) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            charArrayBuffer.sizeCopied = 0;
            return;
        }
        if (charArrayBuffer.data == null || charArrayBuffer.data.length < string2.length()) {
            charArrayBuffer.data = string2.toCharArray();
        } else {
            string2.getChars(0, string2.length(), charArrayBuffer.data, 0);
        }
        charArrayBuffer.sizeCopied = string2.length();
    }

    @KeepForSdk
    @RecentlyNonNull
    public static byte[] loadImageBytes(@RecentlyNonNull Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

