/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;

@KeepForSdk
public final class DeviceProperties {
    @Nullable
    private static Boolean zza;
    @Nullable
    private static Boolean zzb;
    @Nullable
    private static Boolean zzc;
    @Nullable
    private static Boolean zzd;
    @Nullable
    private static Boolean zze;
    @Nullable
    private static Boolean zzf;
    @Nullable
    private static Boolean zzg;
    @Nullable
    private static Boolean zzh;

    private DeviceProperties() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isTablet(@RecentlyNonNull Resources resources) {
        if (resources == null) {
            return false;
        }
        if (zza == null) {
            boolean bl;
            if ((resources.getConfiguration().screenLayout & 0xF) > 3) {
                bl = true;
            } else {
                if (zzb == null) {
                    resources = resources.getConfiguration();
                    boolean bl2 = (resources.screenLayout & 0xF) <= 3 ? resources.smallestScreenWidthDp >= 600 : false;
                    zzb = bl2;
                }
                bl = zzb != false;
            }
            zza = bl;
        }
        return zza;
    }

    @TargetApi(value=20)
    @KeepForSdk
    public static boolean isWearable(@RecentlyNonNull Context context) {
        return DeviceProperties.isWearable(context.getPackageManager());
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=20)
    @KeepForSdk
    public static boolean isWearable(@RecentlyNonNull PackageManager packageManager) {
        if (zzc == null) {
            boolean bl = PlatformVersion.isAtLeastKitKatWatch() ? packageManager.hasSystemFeature("android.hardware.type.watch") : false;
            zzc = bl;
        }
        return zzc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=26)
    @KeepForSdk
    public static boolean isWearableWithoutPlayStore(@RecentlyNonNull Context context) {
        if (!DeviceProperties.isWearable(context)) return false;
        if (!PlatformVersion.isAtLeastN()) return true;
        if (!DeviceProperties.zza(context)) return false;
        if (!PlatformVersion.isAtLeastO()) return true;
        return false;
    }

    @TargetApi(value=21)
    @KeepForSdk
    public static boolean isSidewinder(@RecentlyNonNull Context context) {
        return DeviceProperties.zza(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isLatchsky(@RecentlyNonNull Context context) {
        if (zze == null) {
            boolean bl = (context = context.getPackageManager()).hasSystemFeature("com.google.android.feature.services_updater") ? context.hasSystemFeature("cn.google.services") : false;
            zze = bl;
        }
        return zze;
    }

    @Deprecated
    @KeepForSdk
    public static boolean isFeaturePhone(@RecentlyNonNull Context context) {
        return false;
    }

    @KeepForSdk
    public static boolean isAuto(@RecentlyNonNull Context context) {
        return DeviceProperties.isAuto(context.getPackageManager());
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isAuto(@RecentlyNonNull PackageManager packageManager) {
        if (zzg == null) {
            boolean bl = PlatformVersion.isAtLeastO() ? packageManager.hasSystemFeature("android.hardware.type.automotive") : false;
            zzg = bl;
        }
        return zzg;
    }

    @KeepForSdk
    public static boolean isTv(@RecentlyNonNull Context context) {
        return DeviceProperties.isTv(context.getPackageManager());
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isTv(@RecentlyNonNull PackageManager packageManager) {
        if (zzh == null) {
            boolean bl = !packageManager.hasSystemFeature("com.google.android.tv") ? (!packageManager.hasSystemFeature("android.hardware.type.television") ? packageManager.hasSystemFeature("android.software.leanback") : true) : true;
            zzh = bl;
        }
        return zzh;
    }

    @KeepForSdk
    public static boolean isUserBuild() {
        return "user".equals(Build.TYPE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=21)
    public static boolean zza(@RecentlyNonNull Context context) {
        if (zzd == null) {
            boolean bl = PlatformVersion.isAtLeastLollipop() ? context.getPackageManager().hasSystemFeature("cn.google") : false;
            zzd = bl;
        }
        return zzd;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean zzb(@RecentlyNonNull Context context) {
        if (zzf == null) {
            boolean bl = !context.getPackageManager().hasSystemFeature("android.hardware.type.iot") ? context.getPackageManager().hasSystemFeature("android.hardware.type.embedded") : true;
            zzf = bl;
        }
        return zzf;
    }
}

